/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates.config;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.statet.ltk.ui.templates.config.RegistryTemplateCategory;
import org.eclipse.statet.ltk.ui.templates.config.TemplateCategory;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CodeTemplateConfigurationRegistry {
    private static final String CATEGORY_ELEMENT = "category";
    private final String extensionPointId;
    private final List<TemplateCategory> categories;

    public CodeTemplateConfigurationRegistry(String extensionPointId) {
        this.extensionPointId = extensionPointId;
        this.categories = new ArrayList<TemplateCategory>();
        this.load(this.categories);
    }

    protected void load(List<TemplateCategory> categories) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointId);
        int i = 0;
        while (i < elements.length) {
            switch (elements[i].getName()) {
                case "category": {
                    this.createCategory(elements[i]);
                }
            }
            ++i;
        }
    }

    private void createCategory(IConfigurationElement element) {
        String id = this.loadRequiredText(element, "id");
        ImageDescriptor image = this.loadImage(element, "image");
        String label = this.loadRequiredText(element, "label");
        ImageDescriptor itemImage = this.loadImage(element, "itemImage");
        if (id != null && label != null) {
            this.categories.add(new RegistryTemplateCategory(id.intern(), image, label, itemImage, element));
        }
    }

    String loadRequiredText(IConfigurationElement element, String attrName) {
        String value = element.getAttribute(attrName);
        if (value != null && !value.isEmpty()) {
            return value;
        }
        return null;
    }

    ImageDescriptor loadImage(IConfigurationElement element, String attrName) {
        String path = element.getAttribute(attrName);
        if (path != null) {
            return AbstractUIPlugin.imageDescriptorFromPlugin((String)element.getContributor().getName(), (String)path);
        }
        return null;
    }

    public List<? extends TemplateCategory> getCategories() {
        return this.categories;
    }
}

