/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.jcommons.runtime;

import org.eclipse.statet.internal.jcommons.runtime.CommonJavaAppEnvironment;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.runtime.AppEnvironment;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;

@NonNullByDefault
public class CommonsRuntime {
    private static @Nullable AppEnvironment environment;

    public static synchronized void init(AppEnvironment environment) {
        if (environment == null) {
            throw new NullPointerException("environment");
        }
        AppEnvironment current = CommonsRuntime.environment;
        if (current != null) {
            throw new IllegalStateException(String.format("Already initialized by '%1$s'.", current.getEnvId()));
        }
        CommonsRuntime.environment = environment;
        CommonsRuntime.log(new InfoStatus("org.eclipse.statet.jcommons.util", "CommonsRuntime initialized with: " + environment));
    }

    public static synchronized void check(boolean autoInit) throws StatusException {
        AppEnvironment current = environment;
        if (current != null) {
            return;
        }
        if (!autoInit) {
            throw new StatusException(new ErrorStatus("org.eclipse.statet.jcommons.util", "CommonsRuntime is not initialized."));
        }
        CommonsRuntime.init(new CommonJavaAppEnvironment());
    }

    public static AppEnvironment getEnvironment() {
        return environment;
    }

    public static void log(Status status) {
        AppEnvironment environment = CommonsRuntime.environment;
        if (environment != null) {
            environment.log(status);
        } else {
            (switch (status.getSeverity()) {
                case 0, 1 -> System.out;
                default -> System.err;
            }).print(status.toString());
        }
    }

    private CommonsRuntime() {
    }
}

