/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.net.core.sshd.agent;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.agent.SshAgentServer;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.Session;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.agent.SshAgentClient;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.net.core.ssh.OpenSshConfigUtils;

@NonNullByDefault
public class StatetSshAgentFactory
implements SshAgentFactory {
    private final ConnectorFactory factory;
    private final Path homeDir;

    public StatetSshAgentFactory(ConnectorFactory factory, Path homeDir) {
        this.factory = factory;
        this.homeDir = homeDir;
    }

    public List<ChannelFactory> getChannelForwardingFactories(FactoryManager manager) {
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public @Nullable SshAgent createClient(@Nullable Session session, FactoryManager manager) throws IOException {
        ConnectorFactory.ConnectorDescriptor defaultConnector;
        String identityAgent = null;
        Session session2 = session;
        if (session2 instanceof JGitClientSession) {
            void jgitSession;
            JGitClientSession jGitClientSession = (JGitClientSession)session2;
            JGitClientSession cfr_ignored_0 = (JGitClientSession)session2;
            HostConfigEntry hostConfig = jgitSession.getHostConfigEntry();
            if (hostConfig != null) {
                identityAgent = hostConfig.getProperty("IdentityAgent", null);
            }
        }
        if (identityAgent == null && (defaultConnector = this.factory.getDefaultConnector()) != null) {
            identityAgent = defaultConnector.getIdentityAgent();
        }
        if (OpenSshConfigUtils.parseNone(identityAgent)) {
            return null;
        }
        return new SshAgentClient(this.factory.create(identityAgent, this.homeDir.toFile()));
    }

    public @Nullable SshAgentServer createServer(ConnectionService service) throws IOException {
        return null;
    }
}

