/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.statet.internal.eutils.autonature.AutoConfig;
import org.eclipse.statet.internal.eutils.autonature.ConfiguratorTask;
import org.eclipse.statet.internal.eutils.autonature.ContentTypeConfig;
import org.eclipse.statet.internal.eutils.autonature.NatureTask;
import org.eclipse.statet.internal.eutils.autonature.Task;

public class ConfigManager
implements IEclipsePreferences.IPreferenceChangeListener {
    private static final String EXTENSION_POINT_ID = "org.eclipse.statet.autonature.AutoConfigurations";
    static final String ON_FILE_CONTENT_CONTRIB = "onFileContent";
    private static final String LABEL_ATTR_NAME = "label";
    static final String CLASS_ATTR_NAME = "class";
    private static final String CONTENT_TYPE_ID_ATTR_NAME = "contentTypeId";
    private static final String ENABLE_ATTR_NAME = "enable";
    private static final String ENSURE_PROJECT_NATURE_ELEMENT_NAME = "ensureProjectNature";
    private static final String RUN_PROJECT_CONFIGURATOR_ELEMENT_NAME = "runProjectConfigurator";
    private static final String NATURE_ID_ATTR_NAME = "natureId";
    static final String PREF_QUALIFIER = "org.eclipse.statet.eutils.autonature/configurations";
    public static final byte AUTO_MODE = 1;
    public static final byte MANUAL_MODE = 2;
    private static final AutoConfig DISABLED = new AutoConfig.Dummy("disabled");
    private final Map<String, AutoConfig> contentConfigs = new HashMap<String, AutoConfig>();
    private final Map<String, AutoConfig> activeContentTasks = new HashMap<String, AutoConfig>();
    private final HashMap<String, NatureTask> natureTasks = new HashMap();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Job updateJob;

    public ConfigManager() {
        this.loadContributions();
        this.updateActiveTasks();
        InstanceScope.INSTANCE.getNode(PREF_QUALIFIER).addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
    }

    private void loadContributions() {
        IConfigurationElement[] contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        IEclipsePreferences defaultsNode = DefaultScope.INSTANCE.getNode(PREF_QUALIFIER);
        IConfigurationElement[] iConfigurationElementArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            String contentTypeId;
            IConfigurationElement contribution = iConfigurationElementArray[n2];
            String name = contribution.getName();
            if (name.equals(ON_FILE_CONTENT_CONTRIB) && (contentTypeId = contribution.getAttribute(CONTENT_TYPE_ID_ATTR_NAME)) != null && !contentTypeId.isEmpty()) {
                contentTypeId = contentTypeId.intern();
                List<Task> tasks = this.loadTasks(contribution.getChildren());
                if (!tasks.isEmpty()) {
                    ContentTypeConfig config = new ContentTypeConfig(contentTypeId, tasks);
                    defaultsNode.putBoolean(config.getEnabledPrefKey(), Boolean.parseBoolean(contribution.getAttribute(ENABLE_ATTR_NAME)));
                    this.contentConfigs.put(contentTypeId, config);
                }
            }
            ++n2;
        }
        for (NatureTask task : this.natureTasks.values()) {
            task.finish();
        }
    }

    private List<Task> loadTasks(IConfigurationElement[] tasksElements) {
        ArrayList<Task> tasks = new ArrayList<Task>(tasksElements.length);
        int i = 0;
        while (i < tasksElements.length) {
            IConfigurationElement taskElement = tasksElements[i];
            switch (taskElement.getName()) {
                case "ensureProjectNature": {
                    String natureId = taskElement.getAttribute(NATURE_ID_ATTR_NAME);
                    if (natureId == null || natureId.isEmpty()) break;
                    tasks.add(this.getNatureTask(natureId));
                    break;
                }
                case "runProjectConfigurator": {
                    String className;
                    String label = taskElement.getAttribute(LABEL_ATTR_NAME);
                    if (label == null || label.isEmpty() || (className = taskElement.getAttribute(CLASS_ATTR_NAME)) == null || className.isEmpty()) break;
                    tasks.add(this.getConfiguratorTask(label, taskElement));
                    break;
                }
            }
            ++i;
        }
        this.checkTasks(tasks);
        return tasks;
    }

    /*
     * WARNING - void declaration
     */
    private void checkTasks(List<Task> tasks) {
        if (tasks.size() <= 1) {
            return;
        }
        NatureTask prev = null;
        for (Task task : tasks) {
            void current;
            Task task2 = task;
            if (!(task2 instanceof NatureTask)) continue;
            NatureTask cfr_ignored_0 = (NatureTask)task2;
            NatureTask cfr_ignored_1 = (NatureTask)task2;
            if (prev != null) {
                current.addPrev(prev);
            }
            prev = current;
        }
    }

    private NatureTask getNatureTask(String natureId) {
        NatureTask task = this.natureTasks.get(natureId);
        if (task == null) {
            natureId = natureId.intern();
            IProjectNatureDescriptor nature = ResourcesPlugin.getWorkspace().getNatureDescriptor(natureId);
            task = nature != null ? new NatureTask(natureId, nature.getLabel(), Arrays.asList(nature.getRequiredNatureIds())) : new NatureTask(natureId, null, Collections.emptyList());
            this.natureTasks.put(natureId, task);
            for (String requiredId : task.getRequiredNatureIds()) {
                task.addPrev(this.getNatureTask(requiredId));
            }
        }
        return task;
    }

    private ConfiguratorTask getConfiguratorTask(String label, IConfigurationElement taskElement) {
        return new ConfiguratorTask(label, taskElement.getAttribute(NATURE_ID_ATTR_NAME), taskElement);
    }

    public synchronized void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (this.updateJob == null) {
            this.updateJob = new UpdateJob();
        }
        this.updateJob.schedule(100L);
    }

    private void updateActiveTasks() {
        IPreferencesService preferences = Platform.getPreferencesService();
        Iterator<Map.Entry<String, AutoConfig>> iterator = this.contentConfigs.entrySet().iterator();
        while (iterator.hasNext()) {
            AutoConfig config;
            Map.Entry<String, AutoConfig> entry;
            this.activeContentTasks.put(entry.getKey(), preferences.getBoolean(PREF_QUALIFIER, (config = (entry = iterator.next()).getValue()).getEnabledPrefKey(), false, null) ? config : DISABLED);
        }
    }

    public List<AutoConfig> getConfigs(byte mode) {
        ArrayList<AutoConfig> list;
        this.lock.readLock().lock();
        try {
            list = new ArrayList<AutoConfig>(this.contentConfigs.values());
        }
        finally {
            this.lock.readLock().unlock();
        }
        Iterator<AutoConfig> iter = list.iterator();
        while (iter.hasNext()) {
            AutoConfig config = iter.next();
            if (config.isAvailable() && config.isSupported(mode)) continue;
            iter.remove();
        }
        return list;
    }

    public boolean hasActiveConfigs() {
        this.lock.readLock().lock();
        try {
            boolean bl = !this.activeContentTasks.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public AutoConfig getConfig(IContentType contentType, byte mode) {
        this.lock.readLock().lock();
        try {
            while (contentType != null) {
                AutoConfig config = this.activeContentTasks.get(contentType.getId());
                if (config != null && config.isSupported(mode)) {
                    AutoConfig autoConfig = config != DISABLED ? config : null;
                    return autoConfig;
                }
                contentType = contentType.getBaseType();
            }
            return null;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public List<String> arrangeNatures(List<String> natureIds, int newIdx) {
        this.lock.readLock().lock();
        try {
            Collections.sort(natureIds.subList(newIdx, natureIds.size()));
            int i = 0;
            while (i < natureIds.size()) {
                NatureTask task;
                block4: while ((task = this.natureTasks.get(natureIds.get(i))) != null) {
                    for (String requiredId : task.getRequiredNatureIds()) {
                        if (natureIds.contains(requiredId)) continue;
                        natureIds.add(i, requiredId);
                        continue block4;
                    }
                }
                ++i;
            }
            int n = natureIds.size();
            int i2 = 0;
            while (i2 < n) {
                int counter = n - i2;
                block7: while (counter > 0) {
                    String natureId = natureIds.get(i2);
                    NatureTask task = this.natureTasks.get(natureId);
                    if (task == null) break;
                    int j = n - 1;
                    while (j > i2) {
                        if (!task.isSubsequentTo(natureIds.get(j))) {
                            --j;
                            continue;
                        }
                        natureIds.remove(i2);
                        natureIds.add(j, natureId);
                        --counter;
                        continue block7;
                    }
                    break block7;
                }
                ++i2;
            }
            List<String> list = natureIds;
            return list;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private class UpdateJob
    extends Job {
        public UpdateJob() {
            super("Update Auto Project Configuration");
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(20);
        }

        protected IStatus run(IProgressMonitor monitor) {
            ConfigManager.this.lock.writeLock().lock();
            try {
                ConfigManager.this.updateActiveTasks();
            }
            finally {
                ConfigManager.this.lock.writeLock().unlock();
            }
            return Status.OK_STATUS;
        }
    }
}

