/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.statet.ecommons.ui.viewers.AbstractPostSelectionProvider;

public class PostSelectionProviderProxy
extends AbstractPostSelectionProvider {
    private final ISelectionChangedListener fSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PostSelectionProviderProxy.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)PostSelectionProviderProxy.this, PostSelectionProviderProxy.this.getSelection(event.getSelection())));
        }
    };
    private final ISelectionChangedListener fPostSelectionChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            PostSelectionProviderProxy.this.firePostSelectionChanged(new SelectionChangedEvent((ISelectionProvider)PostSelectionProviderProxy.this, PostSelectionProviderProxy.this.getSelection(event.getSelection())));
        }
    };
    protected ISelectionProvider fSelectionProvider;

    public PostSelectionProviderProxy(ISelectionProvider selectionProvider) {
        this.setSelectionProvider(selectionProvider);
    }

    public PostSelectionProviderProxy() {
    }

    protected void setSelectionProvider(ISelectionProvider selectionProvider) {
        if (this.fSelectionProvider == selectionProvider) {
            return;
        }
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.removeSelectionChangedListener(this.fSelectionChangedListener);
            if (this.fSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.fSelectionProvider).removePostSelectionChangedListener(this.fPostSelectionChangedListener);
            } else {
                this.fSelectionProvider.removeSelectionChangedListener(this.fPostSelectionChangedListener);
            }
        }
        this.fSelectionProvider = selectionProvider;
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.addSelectionChangedListener(this.fSelectionChangedListener);
            if (this.fSelectionProvider instanceof IPostSelectionProvider) {
                ((IPostSelectionProvider)this.fSelectionProvider).addPostSelectionChangedListener(this.fPostSelectionChangedListener);
            } else {
                this.fSelectionProvider.addSelectionChangedListener(this.fPostSelectionChangedListener);
            }
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection(this.getSelection()));
        this.fireSelectionChanged(event);
        this.firePostSelectionChanged(event);
    }

    protected ISelectionProvider getSelectionProvider() {
        return this.fSelectionProvider;
    }

    public void setSelection(ISelection selection) {
        if (this.fSelectionProvider != null) {
            this.fSelectionProvider.setSelection(selection);
        }
    }

    public ISelection getSelection() {
        return this.getSelection(this.fSelectionProvider != null ? this.fSelectionProvider.getSelection() : null);
    }

    protected ISelection getSelection(ISelection originalSelection) {
        return originalSelection != null ? originalSelection : StructuredSelection.EMPTY;
    }
}

