/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.dataeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.viewers.BasicCustomViewer;
import org.eclipse.statet.ecommons.waltable.NatTable;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.config.IConfiguration;
import org.eclipse.statet.ecommons.waltable.config.LayoutSizeConfig;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.copy.CopyToClipboardCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommand;
import org.eclipse.statet.ecommons.waltable.core.command.LayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.core.coordinate.LRangeList;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.data.ControlData;
import org.eclipse.statet.ecommons.waltable.core.data.DataProvider;
import org.eclipse.statet.ecommons.waltable.core.data.SpanningDataProvider;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerListener;
import org.eclipse.statet.ecommons.waltable.core.layer.events.DimGeneralStrucuralChangeEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.events.DimPositionsVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.events.GeneralVisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.core.layer.events.VisualChangeEvent;
import org.eclipse.statet.ecommons.waltable.data.core.DataLayer;
import org.eclipse.statet.ecommons.waltable.data.core.SpanningDataLayer;
import org.eclipse.statet.ecommons.waltable.freeze.FreezeLayer;
import org.eclipse.statet.ecommons.waltable.freeze.core.CompositeFreezeLayer;
import org.eclipse.statet.ecommons.waltable.grid.AlternatingRowLabelContributor;
import org.eclipse.statet.ecommons.waltable.grid.core.GridLayer;
import org.eclipse.statet.ecommons.waltable.grid.core.data.DefaultCornerDataProvider;
import org.eclipse.statet.ecommons.waltable.grid.core.labeled.ExtColumnHeaderLayer;
import org.eclipse.statet.ecommons.waltable.grid.core.labeled.ExtGridLayer;
import org.eclipse.statet.ecommons.waltable.grid.core.labeled.ExtRowHeaderLayer;
import org.eclipse.statet.ecommons.waltable.grid.core.labeled.LabelCornerLayer;
import org.eclipse.statet.ecommons.waltable.grid.core.layers.ColumnHeaderLayer;
import org.eclipse.statet.ecommons.waltable.grid.core.layers.CornerLayer;
import org.eclipse.statet.ecommons.waltable.grid.core.layers.RowHeaderLayer;
import org.eclipse.statet.ecommons.waltable.layer.cell.AggregrateConfigLabelAccumulator;
import org.eclipse.statet.ecommons.waltable.layer.cell.CellLabelContributor;
import org.eclipse.statet.ecommons.waltable.resize.core.InitializeAutoResizeCommandHandler;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectAllCommand;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectDimPositionsCommand;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectRelativeCommandHandler;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionEvent;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.ecommons.waltable.sort.core.ClearSortCommand;
import org.eclipse.statet.ecommons.waltable.sort.core.ClearSortCommandHandler;
import org.eclipse.statet.ecommons.waltable.sort.core.SortDimPositionCommand;
import org.eclipse.statet.ecommons.waltable.sort.core.SortDirection;
import org.eclipse.statet.ecommons.waltable.sort.core.SortHeaderLayer;
import org.eclipse.statet.ecommons.waltable.sort.core.SortModel;
import org.eclipse.statet.ecommons.waltable.sort.core.SortPositionCommandHandler;
import org.eclipse.statet.ecommons.waltable.tickupdate.config.DefaultTickUpdateConfiguration;
import org.eclipse.statet.ecommons.waltable.ui.ITableUIContext;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayer;
import org.eclipse.statet.ecommons.waltable.viewport.core.ViewportLayerDim;
import org.eclipse.statet.internal.r.ui.dataeditor.AbstractRDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.FTableDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.FindFilter;
import org.eclipse.statet.internal.r.ui.dataeditor.FindListener;
import org.eclipse.statet.internal.r.ui.dataeditor.FindTask;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatter;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFormatterConverter;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataFrameDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RMatrixDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.RVectorDataProvider;
import org.eclipse.statet.internal.r.ui.dataeditor.ResolveCellIndexes;
import org.eclipse.statet.internal.r.ui.intable.DataTable;
import org.eclipse.statet.internal.r.ui.intable.PresentationConfig;
import org.eclipse.statet.internal.r.ui.intable.RDataLayer;
import org.eclipse.statet.internal.r.ui.intable.TableLayers;
import org.eclipse.statet.internal.r.ui.intable.UIBindings;
import org.eclipse.statet.jcommons.collections.CopyOnWriteList;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.ui.dataeditor.DataViewDescription;
import org.eclipse.statet.r.ui.dataeditor.RDataTableCallbacks;
import org.eclipse.statet.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.r.ui.dataeditor.RDataTableListener;
import org.eclipse.statet.r.ui.dataeditor.RDataTableSelection;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RVector;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.statushandlers.StatusManager;

@NonNullByDefault
public class RDataTableViewer
extends BasicCustomViewer<RDataTableSelection> {
    private static final RDataTableSelection NO_SELECTION = new RDataTableSelection(null, null, null, null, null);
    private static final int CHECK_LABEL = 1;
    private final Display display;
    private final Composite composite;
    private final StackLayout layout;
    private final Label messageControl;
    private @Nullable Composite reloadControl;
    private final RDataTableCallbacks callbacks;
    private RDataTableInput input;
    private AbstractRDataProvider<?> dataProvider;
    private @Nullable TableLayers tableLayers;
    private boolean tableInitialized;
    private @Nullable DataViewDescription dataViewDescription;
    private PositionCoordinate currentAnchor;
    private @Nullable PositionCoordinate currentLastSelectedCell;
    private final CopyOnWriteList<FindListener> findListeners = new CopyOnWriteList();
    private final CopyOnWriteList<RDataTableListener> tableListeners = new CopyOnWriteList();
    private final RDataFormatter formatter = new RDataFormatter();
    private @Nullable ResolveCellIndexes setAnchorByData;

    public RDataTableViewer(Composite parent, RDataTableCallbacks callbacks) {
        super(parent.getDisplay(), (ISelection)NO_SELECTION);
        this.composite = new Composite(parent, 0);
        if (callbacks == null) {
            throw new NullPointerException("callbacks");
        }
        this.display = this.composite.getDisplay();
        this.callbacks = callbacks;
        this.layout = new StackLayout();
        this.composite.setLayout((Layout)this.layout);
        this.messageControl = new Label(this.composite, 0);
        this.showDummy("Preparing...");
        this.initSelectionController(NO_SELECTION, 50000000L);
    }

    public final Control getControl() {
        return this.composite;
    }

    public final boolean isDisposed() {
        return this.composite.isDisposed();
    }

    public RDataTableInput getInput() {
        return this.input;
    }

    public void setInput(@Nullable Object input) {
        throw new UnsupportedOperationException();
    }

    protected void initTable(final RDataTableInput input, final AbstractRDataProvider<? extends RObject> dataProvider) {
        GridLayer gridLayer;
        CornerLayer cornerLayer;
        DataProvider headerDataProvider;
        this.input = input;
        this.dataProvider = dataProvider;
        final PresentationConfig presentation = PresentationConfig.getInstance(this.display);
        final TableLayers layers = new TableLayers();
        layers.dataLayer = new RDataLayer(dataProvider, presentation.getBaseSizeConfig());
        if (!this.dataProvider.getAllColumnsEqual()) {
            AggregrateConfigLabelAccumulator aggregrateConfigLabelAccumulator = new AggregrateConfigLabelAccumulator();
        }
        layers.selectionLayer = new SelectionLayer((Layer)layers.dataLayer, false);
        layers.selectionLayer.addConfiguration((IConfiguration)new UIBindings.SelectionConfiguration());
        layers.selectionLayer.addConfiguration((IConfiguration)new DefaultTickUpdateConfiguration());
        layers.viewportLayer = new ViewportLayer((Layer)layers.selectionLayer);
        FreezeLayer freezeLayer = new FreezeLayer((Layer)layers.selectionLayer);
        CompositeFreezeLayer compositeFreezeLayer = new CompositeFreezeLayer(freezeLayer, layers.viewportLayer, layers.selectionLayer, true);
        layers.topBodyLayer = compositeFreezeLayer;
        DataProvider headerDataProvider2 = dataProvider.getColumnDataProvider();
        layers.dataColumnHeaderLayer = headerDataProvider2 instanceof SpanningDataProvider ? new SpanningDataLayer((SpanningDataProvider)headerDataProvider2, 0x10000000000000L, 10, 0x20000000000000L, 10) : new DataLayer(headerDataProvider2, 0x10000000000000L, 10, 0x20000000000000L, 10);
        ColumnHeaderLayer layer = new ColumnHeaderLayer((Layer)layers.dataColumnHeaderLayer, layers.topBodyLayer, layers.selectionLayer, false, presentation.getHeaderLayerPainter());
        layer.addConfiguration((IConfiguration)new UIBindings.ColumnHeaderConfiguration());
        layers.topColumnHeaderLayer = layer;
        SortModel sortModel = dataProvider.getSortModel();
        if (sortModel != null) {
            SortHeaderLayer sortHeaderLayer = new SortHeaderLayer(layers.topColumnHeaderLayer, sortModel, false);
            sortHeaderLayer.addConfiguration((IConfiguration)new UIBindings.SortConfiguration());
            layers.topColumnHeaderLayer = sortHeaderLayer;
        }
        layers.dataRowHeaderLayer = (headerDataProvider = dataProvider.getRowDataProvider()) instanceof SpanningDataProvider ? new SpanningDataLayer((SpanningDataProvider)headerDataProvider, 0x20000000000000L, 10, 0x10000000000000L, 10) : new DataLayer(headerDataProvider, 0x20000000000000L, 10, 0x10000000000000L, 10);
        layers.topRowHeaderLayer = new RowHeaderLayer((Layer)layers.dataRowHeaderLayer, layers.topBodyLayer, layers.selectionLayer, false, presentation.getHeaderLayerPainter());
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider(layers.dataColumnHeaderLayer.getDataProvider(), layers.dataRowHeaderLayer.getDataProvider());
        if (dataProvider.getColumnLabelProvider() != null || dataProvider.getRowLabelProvider() != null) {
            layers.topColumnHeaderLayer = new ExtColumnHeaderLayer(layers.topColumnHeaderLayer);
            layers.topRowHeaderLayer = new ExtRowHeaderLayer(layers.topRowHeaderLayer);
            cornerLayer = new LabelCornerLayer((Layer)new DataLayer((DataProvider)cornerDataProvider, 0x20000000000000L, 10, 0x20000000000000L, 10), layers.topRowHeaderLayer, layers.topColumnHeaderLayer, dataProvider.getColumnLabelProvider(), dataProvider.getRowLabelProvider(), false, presentation.getHeaderLabelLayerPainter());
            gridLayer = new ExtGridLayer(layers.topBodyLayer, layers.topColumnHeaderLayer, layers.topRowHeaderLayer, (Layer)cornerLayer, false);
        } else {
            cornerLayer = new CornerLayer((Layer)new DataLayer((DataProvider)cornerDataProvider, 0x20000000000000L), layers.topRowHeaderLayer, layers.topColumnHeaderLayer, false, presentation.getHeaderLayerPainter());
            gridLayer = new GridLayer(layers.topBodyLayer, layers.topColumnHeaderLayer, layers.topRowHeaderLayer, (Layer)cornerLayer, false);
        }
        gridLayer.addCellLabelContributor("BODY", (CellLabelContributor)new AlternatingRowLabelContributor());
        Runnable configRunnable = new Runnable(){

            @Override
            public void run() {
                TableLayers layers = RDataTableViewer.this.tableLayers;
                if (layers == null) {
                    return;
                }
                LayoutSizeConfig sizeConfig = presentation.getBaseSizeConfig();
                layers.dataLayer.setSizeConfig(sizeConfig);
                layers.dataColumnHeaderLayer.setDefaultRowHeight(sizeConfig.getRowHeight());
                layers.dataRowHeaderLayer.setDefaultColumnWidth(sizeConfig.getCharWidth() * 8 + sizeConfig.getDefaultSpace() * 2);
                if (layers.topColumnHeaderLayer instanceof ExtColumnHeaderLayer) {
                    ((ExtColumnHeaderLayer)layers.topColumnHeaderLayer).setSpaceSize(sizeConfig.getRowHeight());
                    ((ExtRowHeaderLayer)layers.topRowHeaderLayer).setSpaceSize(sizeConfig.getRowHeight());
                }
                presentation.configureRegistry(layers.table.getConfigRegistry());
                layers.table.updateResize();
            }
        };
        presentation.addListener(configRunnable);
        RUIContext uiContext = new RUIContext();
        SelectRelativeCommandHandler commandHandler = new SelectRelativeCommandHandler(layers.selectionLayer);
        layers.viewportLayer.registerCommandHandler((LayerCommandHandler)commandHandler);
        layers.selectionLayer.registerCommandHandler((LayerCommandHandler)commandHandler);
        commandHandler = new CopyToClipboardCommandHandler(layers.selectionLayer, (ITableUIContext)uiContext);
        layers.selectionLayer.registerCommandHandler((LayerCommandHandler)commandHandler);
        commandHandler = new InitializeAutoResizeCommandHandler(layers.selectionLayer);
        gridLayer.registerCommandHandler((LayerCommandHandler)commandHandler);
        if (sortModel != null) {
            commandHandler = new SortPositionCommandHandler(sortModel);
            layers.dataLayer.registerCommandHandler((LayerCommandHandler)commandHandler);
        }
        if (sortModel != null) {
            commandHandler = new ClearSortCommandHandler(sortModel);
            layers.dataLayer.registerCommandHandler((LayerCommandHandler)commandHandler);
        }
        layers.table = new DataTable(this.composite, (Layer)gridLayer);
        layers.table.addConfiguration((IConfiguration)new UIBindings.HeaderContextMenuConfiguration(layers.table, this.callbacks.getWorkbenchPart()));
        layers.table.addConfiguration((IConfiguration)new UIBindings.BodyContextMenuConfiguration(layers.table, this.callbacks.getServiceLocator()));
        layers.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dataProvider.dispose();
            }
        });
        ConfigRegistry registry = layers.table.getConfigRegistry();
        registry.registerAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new RDataFormatterConverter(dataProvider));
        registry.registerAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new RDataFormatterConverter.RowHeader(dataProvider), DisplayMode.NORMAL, "ROW_HEADER");
        this.tableLayers = layers;
        this.tableInitialized = false;
        configRunnable.run();
        layers.table.addLayerListener(new LayerListener(){

            public void handleLayerEvent(LayerEvent event) {
                if (event instanceof SelectionEvent) {
                    RDataTableViewer.this.refreshSelection(0, BasicCustomViewer.UpdateType.DEFAULT_DELAYED_POST, true);
                    return;
                }
                if (event instanceof VisualChangeEvent) {
                    RDataTableViewer.this.refreshSelection(1, BasicCustomViewer.UpdateType.DEFAULT_DELAYED_POST, true);
                    return;
                }
            }
        });
        dataProvider.addDataChangedListener(new AbstractRDataProvider.DataProviderListener(){

            @Override
            public void onInputInitialized(boolean structChanged) {
                if (layers != RDataTableViewer.this.tableLayers || layers.table.isDisposed()) {
                    RDataTableViewer.this.clearDataViewDescription();
                    return;
                }
                if (layers.table != RDataTableViewer.this.layout.topControl) {
                    layers.table.configure();
                }
                if (layers.table != RDataTableViewer.this.layout.topControl) {
                    RDataTableViewer.this.layout.topControl = layers.table;
                    RDataTableViewer.this.composite.layout();
                }
                DataViewDescription viewDescription = RDataTableViewer.this.refreshDataViewDescription(layers);
                if (!RDataTableViewer.this.tableInitialized) {
                    layers.selectionLayer.setSelectionToCell(0L, 0L, true);
                    RDataTableViewer.this.tableInitialized = true;
                } else if (structChanged) {
                    layers.dataLayer.fireLayerEvent((LayerEvent)new DimGeneralStrucuralChangeEvent(layers.dataLayer.getDim(Orientation.VERTICAL)));
                } else {
                    layers.dataLayer.fireLayerEvent((LayerEvent)new GeneralVisualChangeEvent((Layer)layers.dataLayer));
                }
                for (RDataTableListener listener : RDataTableViewer.this.tableListeners) {
                    listener.onInputChanged(input, dataProvider.getDescription(), viewDescription);
                }
                RDataTableViewer.this.refreshSelection(1, BasicCustomViewer.UpdateType.DIRECT, false);
            }

            @Override
            public void onInputFailed(int error) {
                if (error == 1) {
                    RDataTableViewer.this.showReload();
                } else {
                    RDataTableViewer.this.showDummy("An error occurred when loading the table input.");
                    for (RDataTableListener listener : RDataTableViewer.this.tableListeners) {
                        listener.onInputChanged(null, null, null);
                    }
                }
            }

            @Override
            public void onRowsChanged() {
                if (layers != RDataTableViewer.this.tableLayers || layers.table.isDisposed()) {
                    return;
                }
                DataViewDescription dataViewDescription = RDataTableViewer.this.refreshDataViewDescription(layers);
                layers.dataLayer.fireLayerEvent((LayerEvent)new DimGeneralStrucuralChangeEvent(layers.dataLayer.getDim(Orientation.VERTICAL)));
                for (RDataTableListener listener : RDataTableViewer.this.tableListeners) {
                    listener.onDataViewChanged(dataViewDescription);
                }
                RDataTableViewer.this.refreshSelection(1, BasicCustomViewer.UpdateType.DIRECT, false);
            }

            @Override
            public void onRowsChanged(final long beginIdx, final long endIdx) {
                RDataTableViewer.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (layers != (this).RDataTableViewer.this.tableLayers || layers.table.isDisposed()) {
                            return;
                        }
                        layers.dataLayer.fireLayerEvent((LayerEvent)new DimPositionsVisualChangeEvent(layers.dataLayer.getDim(Orientation.VERTICAL), new LRange(beginIdx, endIdx)));
                    }
                });
            }
        });
        dataProvider.addFindListener(this::handleFindEvent);
    }

    public @Nullable NatTable getTable() {
        TableLayers tableLayers = this.tableLayers;
        return tableLayers != null ? tableLayers.table : null;
    }

    protected @Nullable RDataTableSelection fetchSelectionFromWidget(int flags, RDataTableSelection prevSelection) {
        PositionCoordinate lastSelectedCell;
        boolean lastSelectedChanged;
        boolean anchorChanged;
        TableLayers tableLayers = this.tableLayers;
        DataViewDescription viewDescription = this.dataViewDescription;
        if (tableLayers == null || viewDescription == null) {
            return NO_SELECTION;
        }
        SelectionLayer selectionLayer = tableLayers.selectionLayer;
        PositionCoordinate anchor = selectionLayer.getSelectionAnchor();
        PositionCoordinate lastSelected = selectionLayer.getLastSelectedCellPosition();
        if (lastSelected.equals((Object)anchor)) {
            lastSelected = null;
        }
        if (anchorChanged = !anchor.equals((Object)this.currentAnchor)) {
            this.currentAnchor = new PositionCoordinate(anchor);
        }
        if ((lastSelected != null ? lastSelected.equals((Object)this.currentLastSelectedCell) : this.currentLastSelectedCell == null) ? false : (lastSelectedChanged = true)) {
            PositionCoordinate positionCoordinate = this.currentLastSelectedCell = lastSelected != null ? new PositionCoordinate(lastSelected) : null;
        }
        if (!anchorChanged && !lastSelectedChanged && viewDescription == prevSelection.getDataViewDescription() && (flags & 1) == 0) {
            return null;
        }
        String anchorRowLabel = null;
        String anchorColumnLabel = null;
        if (this.currentAnchor.columnPosition >= 0L && this.currentAnchor.rowPosition >= 0L) {
            if (anchorChanged || (flags & 1) != 0) {
                anchorRowLabel = this.getRowLabel(this.currentAnchor.rowPosition);
                if (anchorRowLabel != null && (anchorColumnLabel = this.getColumnLabel(this.currentAnchor.columnPosition)) == null) {
                    anchorRowLabel = null;
                }
            } else {
                anchorRowLabel = prevSelection.getAnchorRowLabel();
                anchorColumnLabel = prevSelection.getAnchorColumnLabel();
            }
        }
        String lastSelectedRowLabel = null;
        String lastSelectedColumnLabel = null;
        if (anchorRowLabel != null && (lastSelectedCell = this.currentLastSelectedCell) != null && lastSelectedCell.columnPosition >= 0L && lastSelectedCell.rowPosition >= 0L) {
            if (lastSelectedChanged || (flags & 1) != 0) {
                lastSelectedRowLabel = this.getRowLabel(lastSelectedCell.rowPosition);
                if (lastSelectedRowLabel != null && (lastSelectedColumnLabel = this.getColumnLabel(lastSelectedCell.columnPosition)) == null) {
                    lastSelectedRowLabel = null;
                }
            } else {
                lastSelectedRowLabel = prevSelection.getLastSelectedCellRowLabel();
                lastSelectedColumnLabel = prevSelection.getLastSelectedCellColumnLabel();
            }
        }
        return new RDataTableSelection(viewDescription, anchorRowLabel, anchorColumnLabel, lastSelectedRowLabel, lastSelectedColumnLabel);
    }

    protected @Nullable String getRowLabel(long row) {
        if (!this.dataProvider.hasRealRows()) {
            return "";
        }
        DataProvider dataProvider = this.dataProvider.getRowDataProvider();
        if (dataProvider.getColumnCount() <= 1L) {
            return this.getHeaderLabel(dataProvider.getDataValue(0L, row, 0, null));
        }
        StringBuilder sb = new StringBuilder();
        long i = 0L;
        while (i < dataProvider.getColumnCount()) {
            String label = this.getHeaderLabel(dataProvider.getDataValue(i, row, 0, null));
            if (label == null) {
                return null;
            }
            sb.append(label);
            sb.append(", ");
            ++i;
        }
        return sb.substring(0, sb.length() - 2);
    }

    protected @Nullable String getColumnLabel(long column) {
        if (!this.dataProvider.hasRealColumns()) {
            return "";
        }
        DataProvider dataProvider = this.dataProvider.getColumnDataProvider();
        if (dataProvider.getRowCount() <= 1L) {
            return this.getHeaderLabel(dataProvider.getDataValue(column, 0L, 0, null));
        }
        StringBuilder sb = new StringBuilder();
        long i = 0L;
        while (i < dataProvider.getRowCount()) {
            String label = this.getHeaderLabel(dataProvider.getDataValue(column, i, 0, null));
            if (label == null) {
                return null;
            }
            sb.append(label);
            sb.append(", ");
            ++i;
        }
        return sb.substring(0, sb.length() - 2);
    }

    private @Nullable String getHeaderLabel(@Nullable Object value) {
        if (value != null) {
            if (value instanceof ControlData && value != AbstractRDataProvider.NA) {
                return null;
            }
            Object displayValue = this.formatter.modelToDisplayValue(value);
            if (displayValue.getClass() == String.class) {
                return (String)displayValue;
            }
            if (displayValue == AbstractRDataProvider.DUMMY) {
                return "";
            }
            return null;
        }
        return this.formatter.modelToDisplayValue(null).toString();
    }

    protected void showDummy(String message) {
        if (this.isDisposed()) {
            return;
        }
        this.messageControl.setText(message);
        this.layout.topControl = this.messageControl;
        this.composite.layout();
    }

    public @Nullable DataViewDescription getDataView() {
        return this.dataViewDescription;
    }

    private DataViewDescription refreshDataViewDescription(TableLayers tableLayers) {
        DataViewDescription viewDescription;
        this.dataViewDescription = viewDescription = new DataViewDescription(ImCollections.newLongList((long[])new long[]{this.dataProvider.getFullRowCount(), this.dataProvider.getColumnCount()}), ImCollections.newLongList((long[])new long[]{this.dataProvider.getRowCount(), this.dataProvider.getColumnCount()}));
        return viewDescription;
    }

    private void clearDataViewDescription() {
        this.dataViewDescription = null;
    }

    public boolean isOK() {
        TableLayers tableLayers = this.tableLayers;
        return tableLayers != null && this.layout.topControl == tableLayers.table;
    }

    public ViewportLayerDim getViewport(Orientation orientation) {
        return this.tableLayers.viewportLayer.getDim(orientation);
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public void find(String expression, boolean selectedOnly, boolean firstInRow, boolean forward) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            PositionCoordinate anchor = tableLayers.selectionLayer.getSelectionAnchor();
            FindTask task = new FindTask(expression, anchor.getRowPosition(), anchor.getColumnPosition(), firstInRow, forward, selectedOnly ? new SelectionFindFilter() : null);
            this.dataProvider.find(task);
        }
    }

    public void addFindListener(FindListener listener) {
        this.findListeners.add((Object)listener);
    }

    public void removeFindListener(FindListener listener) {
        this.findListeners.remove((Object)listener);
    }

    private void handleFindEvent(FindListener.FindEvent event) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            if (event.rowIdx >= 0L) {
                tableLayers.setAnchor(event.colIdx, event.rowIdx, true);
            }
            for (FindListener listener : this.findListeners) {
                listener.handleFindEvent(event);
            }
        }
    }

    public void setInput(final RDataTableInput input) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            this.showDummy("");
            tableLayers.table.dispose();
            tableLayers.table = null;
            this.dataProvider = null;
            this.setAnchorByData = null;
        }
        if (input != null) {
            this.showDummy("Preparing (" + input.getName() + ")...");
            try {
                SystemRunnable runnable = new SystemRunnable(){

                    public String getTypeId() {
                        return "r/dataeditor/init";
                    }

                    public String getLabel() {
                        return "Prepare Data Viewer (" + input.getName() + ")";
                    }

                    public boolean canRunIn(Tool tool) {
                        return true;
                    }

                    public boolean changed(int event, Tool process) {
                        return event != 289;
                    }

                    public void run(ToolService service, ProgressMonitor m) throws StatusException {
                        org.eclipse.core.runtime.Status status;
                        RToolService r = (RToolService)service;
                        AtomicReference<@Nullable AbstractRDataProvider> dataProvider = new AtomicReference<AbstractRDataProvider>();
                        Throwable error = null;
                        try {
                            RObject struct = r.evalData(input.getFullName(), null, 1, 1, m);
                            RCharacterStore classNames = null;
                            FunctionCall call = r.createFunctionCall("class");
                            call.add(input.getFullName());
                            classNames = (RCharacterStore)RDataUtils.checkRCharVector((RObject)call.evalData(m)).getData();
                            switch (struct.getRObjectType()) {
                                case 2: {
                                    dataProvider.set(new RVectorDataProvider(input, (RVector)struct));
                                    break;
                                }
                                case 3: {
                                    RArray array = (RArray)struct;
                                    if (array.getDim().getLength() == 2L) {
                                        if (classNames.contains("ftable")) {
                                            dataProvider.set(new FTableDataProvider(input, array));
                                            break;
                                        }
                                        dataProvider.set(new RMatrixDataProvider(input, array));
                                    }
                                    break;
                                }
                                case 6: {
                                    dataProvider.set(new RDataFrameDataProvider(input, (RDataFrame)struct));
                                    break;
                                }
                            }
                        }
                        catch (CoreException | UnexpectedRDataException e) {
                            error = e;
                        }
                        if (error != null) {
                            status = new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", "An error occurred when preparing the R data viewer.", error);
                            StatusManager.getManager().handle((IStatus)status);
                        } else {
                            status = dataProvider.get() == null ? new org.eclipse.core.runtime.Status(4, "org.eclipse.statet.r.ui", "This R element type is not supported.", null) : null;
                        }
                        RDataTableViewer.this.display.asyncExec(() -> this.lambda$0((IStatus)status, input, dataProvider));
                    }

                    private /* synthetic */ void lambda$0(IStatus iStatus, RDataTableInput rDataTableInput, AtomicReference atomicReference) {
                        RDataTableViewer.this.dataProvider = null;
                        if (RDataTableViewer.this.isDisposed()) {
                            return;
                        }
                        if (iStatus == null) {
                            RDataTableViewer.this.initTable(rDataTableInput, (AbstractRDataProvider)atomicReference.get());
                        } else {
                            RDataTableViewer.this.showDummy(iStatus.getMessage());
                        }
                    }
                };
                Status status = input.getTool().getQueue().add((ToolRunnable)runnable);
                if (status.getSeverity() >= 4) {
                    throw new StatusException(status);
                }
            }
            catch (StatusException e) {
                this.showDummy(e.getLocalizedMessage());
            }
        }
    }

    protected void showReload() {
        Composite reloadControl = this.reloadControl;
        if (reloadControl == null) {
            reloadControl = new Composite(this.composite, 0);
            reloadControl.setLayout((Layout)LayoutUtils.newCompositeGrid((int)4));
            Label label = new Label(reloadControl, 64);
            label.setText("The structure of the R element is changed (columns / data type).");
            label.setLayoutData((Object)new GridData(4, 128, true, false, 4, 1));
            Button button = new Button(reloadControl, 8);
            button.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, false, false), (Button)button));
            button.setText("Refresh");
            button.setToolTipText("Refresh table with old structure");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                    RDataTableViewer.this.refresh();
                }
            });
            button = new Button(reloadControl, 8);
            button.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, false, false), (Button)button));
            button.setText("Reopen");
            button.setToolTipText("Reopen table with new structure");
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                    RDataTableViewer.this.setInput(RDataTableViewer.this.input);
                }
            });
            if (this.callbacks.isCloseSupported()) {
                button = new Button(reloadControl, 8);
                button.setLayoutData((Object)LayoutUtils.hintWidth((GridData)new GridData(4, 0x1000000, false, false), (Button)button));
                button.setText("Close");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(org.eclipse.swt.events.SelectionEvent e) {
                        RDataTableViewer.this.callbacks.close();
                    }
                });
            }
            LayoutUtils.addSmallFiller((Composite)reloadControl, (boolean)true);
            this.reloadControl = reloadControl;
        }
        this.layout.topControl = reloadControl;
        this.composite.layout(true);
    }

    public void setFilter(@Nullable String filter) {
        this.dataProvider.setFilter(filter);
    }

    public RDataTableContentDescription getDescription() {
        return this.dataProvider.getDescription();
    }

    public void addTableListener(RDataTableListener listener) {
        this.tableListeners.add((Object)listener);
        TableLayers tableLayers = this.tableLayers;
        DataViewDescription dataView = this.dataViewDescription;
        if (tableLayers != null && dataView != null) {
            listener.onInputChanged(this.input, this.dataProvider.getDescription(), dataView);
        }
    }

    public void removeTableListener(RDataTableListener listener) {
        this.tableListeners.remove((Object)listener);
    }

    public boolean setFocus() {
        Control control;
        return this.layout != null && (control = this.layout.topControl) != null && control.forceFocus() || this.composite.forceFocus();
    }

    public void revealColumn(long index) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.viewportLayer.getDim(Orientation.HORIZONTAL).movePositionIntoViewport(index);
        }
    }

    public void selectColumns(Collection<LRange> indexes) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            LRangeList columns = LRangeList.toRangeList(indexes);
            long rowIndex = 0L;
            tableLayers.table.doCommand((LayerCommand)new SelectDimPositionsCommand(tableLayers.selectionLayer.getDim(Orientation.HORIZONTAL), 0L, (Collection)columns, 0L, 0, !columns.isEmpty() ? columns.values().first() : Long.MIN_VALUE));
        }
    }

    public void setAnchorViewIdxs(long columnIndex, long rowIndex) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.selectionLayer.setSelectionAnchor(columnIndex, rowIndex, true);
        }
    }

    public long @Nullable [] getAnchorDataIdxs() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            PositionCoordinate coordinate = tableLayers.selectionLayer.getSelectionAnchor();
            if (coordinate.columnPosition < 0L || coordinate.rowPosition < 0L) {
                return null;
            }
            return this.dataProvider.toDataIdxs(coordinate.columnPosition, coordinate.rowPosition);
        }
        return null;
    }

    public void setAnchorDataIdxs(long columnIdx, long rowIdx) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            ResolveCellIndexes data = this.setAnchorByData;
            if (data == null) {
                this.setAnchorByData = data = new SetAnchorByDataIndexes(this.dataProvider);
            }
            data.resolve(columnIdx, rowIdx);
        }
    }

    public void selectAll() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.table.doCommand((LayerCommand)new SelectAllCommand());
        }
    }

    public void sortByColumn(long index, boolean increasing) {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.dataLayer.doCommand((LayerCommand)new SortDimPositionCommand(tableLayers.dataLayer.getDim(Orientation.HORIZONTAL), index, increasing ? SortDirection.ASC : SortDirection.DESC, false));
        }
    }

    public void clearSorting() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            tableLayers.table.doCommand((LayerCommand)new ClearSortCommand());
        }
    }

    public void refresh() {
        TableLayers tableLayers = this.tableLayers;
        if (tableLayers != null) {
            this.dataProvider.reset();
            tableLayers.table.redraw();
        }
    }

    private class RUIContext
    implements ITableUIContext {
        public void run(boolean fork, boolean cancelable, final IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
            IRunnableContext runnableContext = (IRunnableContext)RDataTableViewer.this.callbacks.getServiceLocator().getService(IProgressService.class);
            runnableContext.run(fork, cancelable, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ((RUIContext)RUIContext.this).RDataTableViewer.this.dataProvider.beginOperation(this);
                    try {
                        runnable.run(monitor);
                    }
                    finally {
                        ((RUIContext)RUIContext.this).RDataTableViewer.this.dataProvider.endOperation(this);
                    }
                }
            });
        }

        public void show(IStatus status) {
            StatusManager.getManager().handle(status, 2);
        }
    }

    private class SelectionFindFilter
    implements FindFilter {
        private SelectionFindFilter() {
        }

        @Override
        public boolean match(long rowIdx, long columnIdx) {
            TableLayers tableLayers = RDataTableViewer.this.tableLayers;
            if (tableLayers != null) {
                if (columnIdx >= 0L) {
                    return tableLayers.selectionLayer.isCellPositionSelected(columnIdx, rowIdx);
                }
                return tableLayers.selectionLayer.isRowPositionSelected(rowIdx);
            }
            return false;
        }
    }

    private class SetAnchorByDataIndexes
    extends ResolveCellIndexes {
        public SetAnchorByDataIndexes(AbstractRDataProvider<?> dataProvider) {
            super(dataProvider);
        }

        @Override
        protected void execute(final long columnIndex, final long rowIndex) {
            RDataTableViewer.this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (SetAnchorByDataIndexes.this.getDataProvider() != ((SetAnchorByDataIndexes)SetAnchorByDataIndexes.this).RDataTableViewer.this.dataProvider) {
                        return;
                    }
                    RDataTableViewer.this.setAnchorViewIdxs(columnIndex, rowIndex);
                }
            });
        }
    }
}

