/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.util;

import java.util.ArrayList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.statet.rtm.rtdata.types.RExpr;

public class RtItemLabelUtils {
    public static String getLabelKey(EClass eClass) {
        return "_UI_" + eClass.getName() + "_type";
    }

    public static String getLabelKey(EStructuralFeature eFeature) {
        return "_UI_" + eFeature.getEContainingClass().getName() + "_" + eFeature.getName() + "_feature";
    }

    public static class LabelBuilder {
        private final StringBuilder builder;
        private int detail = -1;

        public LabelBuilder(String label) {
            this.builder = new StringBuilder(label);
        }

        public void appendDetail(String label, RExpr value) {
            if (label != null && value != null) {
                if (this.detail < 0) {
                    this.detail = 1;
                    this.builder.append(" (");
                } else {
                    this.builder.append(", ");
                }
                this.builder.append(label);
                this.builder.append(": ");
                this.builder.append(value.getExpr());
            }
        }

        public void closeDetail() {
            if (this.detail > 0) {
                this.builder.append(")");
            }
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    public static class LabelGenerator {
        private final String baseLabel;
        private final Detail[] details;

        public LabelGenerator(ResourceLocator resourceLocator, EClass eClass, String[] names) {
            this.baseLabel = resourceLocator.getString(RtItemLabelUtils.getLabelKey(eClass), true);
            ArrayList<Detail> details = new ArrayList<Detail>();
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                EStructuralFeature eFeature = eClass.getEStructuralFeature(name);
                if (eFeature != null) {
                    String label = resourceLocator.getString(RtItemLabelUtils.getLabelKey(eFeature));
                    details.add(new Detail(eFeature, label));
                }
                ++n2;
            }
            this.details = details.toArray(new Detail[details.size()]);
        }

        public String createLabel(EObject eObj) {
            LabelBuilder sb = new LabelBuilder(this.baseLabel);
            int i = 0;
            while (i < this.details.length) {
                Object value = eObj.eGet(this.details[i].eFeature);
                if (value != null) {
                    sb.appendDetail(this.details[i].label, (RExpr)value);
                }
                ++i;
            }
            sb.closeDetail();
            return sb.toString();
        }

        private static class Detail {
            private final EStructuralFeature eFeature;
            private final String label;

            public Detail(EStructuralFeature eFeature, String label) {
                this.eFeature = eFeature;
                this.label = label;
            }
        }
    }
}

