/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.ui.actions.ToggleBooleanPreferenceHandler;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.ui.editors.text.EditorsUI;

public class ToggleShowWhitespaceHandler
extends ToggleBooleanPreferenceHandler {
    private final SourceViewer viewer;
    private final IPreferenceStore store;
    private IPainter painter;

    public ToggleShowWhitespaceHandler(Preference<Boolean> pref, SourceViewer viewer, IPreferenceStore store) {
        super(pref, "org.eclipse.ui.edit.text.toggleShowWhitespaceCharacters");
        this.viewer = viewer;
        this.store = store;
        this.handleToggled(this.isPrefEnabled());
    }

    public ToggleShowWhitespaceHandler(Preference<Boolean> pref, SourceViewer viewer) {
        this(pref, viewer, EditorsUI.getPreferenceStore());
    }

    protected SourceViewer getViewer() {
        return this.viewer;
    }

    private void installPainter() {
        if (this.painter != null) {
            return;
        }
        SourceViewer viewer = this.getViewer();
        if (UIAccess.isOkToUse((Viewer)viewer)) {
            this.painter = this.store != null ? new WhitespaceCharacterPainter((ITextViewer)viewer, this.store.getBoolean("showLeadingSpaces"), this.store.getBoolean("showEnclosedSpaces"), this.store.getBoolean("showTrailingSpaces"), this.store.getBoolean("showLeadingIdeographicSpaces"), this.store.getBoolean("showEnclosedIdeographicSpaces"), this.store.getBoolean("showTrailingIdeographicSpaces"), this.store.getBoolean("showLeadingTabs"), this.store.getBoolean("showEnclosedTabs"), this.store.getBoolean("showTrailingTabs"), this.store.getBoolean("showCarriageReturn"), this.store.getBoolean("showLineFeed"), this.store.getInt("whitespaceCharacterAlphaValue")) : new WhitespaceCharacterPainter((ITextViewer)viewer);
            viewer.addPainter(this.painter);
        }
    }

    private void uninstallPainter() {
        if (this.painter == null) {
            return;
        }
        SourceViewer viewer = this.getViewer();
        if (UIAccess.isOkToUse((Viewer)viewer)) {
            viewer.removePainter(this.painter);
        }
        this.painter.deactivate(true);
        this.painter = null;
    }

    protected void handleToggled(boolean enabled) {
        if (enabled) {
            this.installPainter();
        } else {
            this.uninstallPainter();
        }
        super.handleToggled(enabled);
    }

    public void dispose() {
        super.dispose();
    }
}

