/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.ui.tools;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.core.RUtil;

public class ChangeWDRunnable
implements ToolRunnable {
    public static final String TYPE_ID = "r/tools/changeWorkingDir";
    private final IFileStore workingDir;

    public ChangeWDRunnable(IFileStore workingdir) {
        this.workingDir = workingdir;
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public boolean canRunIn(Tool tool) {
        return tool.isProvidingFeatureSet("org.eclipse.statet.r.basic");
    }

    public String getLabel() {
        return Messages.ChangeWorkingDir_Task_label;
    }

    public boolean changed(int event, Tool process) {
        return true;
    }

    public void run(ToolService service, ProgressMonitor m) throws StatusException {
        IRBasicAdapter r = (IRBasicAdapter)service;
        String toolPath = r.getWorkspaceData().toToolPath(this.workingDir);
        try {
            String command = "setwd(\"" + RUtil.escapeCompletely((String)toolPath) + "\")";
            r.submitToConsole(command, m);
        }
        finally {
            r.refreshWorkspaceData(0, m);
        }
    }
}

