/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.edit.editor;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.config.CellConfigAttributes;
import org.eclipse.statet.ecommons.waltable.core.config.ConfigRegistry;
import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Direction;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.style.RegistryStyle;
import org.eclipse.statet.ecommons.waltable.core.style.Style;
import org.eclipse.statet.ecommons.waltable.data.convert.ConversionFailedException;
import org.eclipse.statet.ecommons.waltable.data.convert.IDisplayConverter;
import org.eclipse.statet.ecommons.waltable.data.validate.IDataValidator;
import org.eclipse.statet.ecommons.waltable.data.validate.ValidationFailedException;
import org.eclipse.statet.ecommons.waltable.edit.ActiveCellEditorRegistry;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigAttributes;
import org.eclipse.statet.ecommons.waltable.edit.EditConfigHelper;
import org.eclipse.statet.ecommons.waltable.edit.EditMode;
import org.eclipse.statet.ecommons.waltable.edit.EditSelectionCommand;
import org.eclipse.statet.ecommons.waltable.edit.ICellEditHandler;
import org.eclipse.statet.ecommons.waltable.edit.editor.ICellEditor;
import org.eclipse.statet.ecommons.waltable.edit.editor.IEditErrorHandler;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractCellEditor
implements ICellEditor {
    private boolean closed;
    private Composite parent;
    private ICellEditHandler editHandler;
    protected Style cellStyle;
    protected IDisplayConverter displayConverter;
    protected IDataValidator dataValidator;
    protected EditMode editMode;
    protected LayerCell layerCell;
    protected LabelStack labelStack;
    protected IEditErrorHandler conversionEditErrorHandler;
    protected IEditErrorHandler validationEditErrorHandler;
    protected ConfigRegistry configRegistry;
    protected FocusListener focusListener = new InlineFocusListener();
    protected TraverseListener traverseListener = new InlineTraverseListener();

    @Override
    public final Control activateCell(Composite parent, Object originalCanonicalValue, EditMode editMode, ICellEditHandler editHandler, LayerCell cell, ConfigRegistry configRegistry) {
        this.closed = false;
        this.parent = parent;
        this.editHandler = editHandler;
        this.editMode = editMode;
        this.layerCell = cell;
        this.configRegistry = configRegistry;
        this.labelStack = cell.getLabels();
        List<String> configLabels = this.labelStack.getLabels();
        this.displayConverter = configRegistry.getAttribute(CellConfigAttributes.DISPLAY_CONVERTER, DisplayMode.EDIT, configLabels);
        this.cellStyle = new RegistryStyle(configRegistry, CellConfigAttributes.CELL_STYLE, DisplayMode.EDIT, configLabels);
        this.dataValidator = configRegistry.getAttribute(EditConfigAttributes.DATA_VALIDATOR, DisplayMode.EDIT, configLabels);
        this.conversionEditErrorHandler = EditConfigHelper.getEditErrorHandler(configRegistry, EditConfigAttributes.CONVERSION_ERROR_HANDLER, configLabels);
        this.validationEditErrorHandler = EditConfigHelper.getEditErrorHandler(configRegistry, EditConfigAttributes.VALIDATION_ERROR_HANDLER, configLabels);
        return this.activateCell(parent, originalCanonicalValue);
    }

    protected abstract Control activateCell(Composite var1, Object var2);

    @Override
    public long getColumnPosition() {
        return this.layerCell.getColumnPosition();
    }

    @Override
    public long getRowPosition() {
        return this.layerCell.getRowPosition();
    }

    @Override
    public Object getCanonicalValue() {
        return this.getCanonicalValue(this.conversionEditErrorHandler);
    }

    @Override
    public Object getCanonicalValue(IEditErrorHandler conversionErrorHandler) {
        return this.handleConversion(this.getEditorValue(), conversionErrorHandler);
    }

    protected Object handleConversion(Object displayValue, IEditErrorHandler conversionErrorHandler) {
        Object canonicalValue;
        try {
            canonicalValue = this.displayConverter != null ? this.displayConverter.displayToCanonicalValue(this.layerCell, this.configRegistry, displayValue) : displayValue;
            conversionErrorHandler.removeError(this);
        }
        catch (ConversionFailedException e) {
            conversionErrorHandler.displayError(this, e);
            throw e;
        }
        catch (Exception e) {
            conversionErrorHandler.displayError(this, e);
            throw new ConversionFailedException(e.getMessage(), e);
        }
        return canonicalValue;
    }

    @Override
    public void setCanonicalValue(Object canonicalValue) {
        Object displayValue = this.displayConverter != null ? this.displayConverter.canonicalToDisplayValue(this.layerCell, this.configRegistry, canonicalValue) : canonicalValue;
        this.setEditorValue(displayValue);
    }

    @Override
    public boolean validateCanonicalValue(Object canonicalValue) {
        return this.validateCanonicalValue(canonicalValue, this.validationEditErrorHandler);
    }

    @Override
    public boolean validateCanonicalValue(Object canonicalValue, IEditErrorHandler validationEditErrorHandler) {
        if (this.dataValidator != null) {
            try {
                boolean validationResult = this.dataValidator.validate(this.layerCell, this.configRegistry, canonicalValue);
                if (!validationResult) {
                    throw new ValidationFailedException(Messages.getString("AbstractCellEditor.validationFailure"));
                }
                validationEditErrorHandler.removeError(this);
                return validationResult;
            }
            catch (Exception e) {
                validationEditErrorHandler.displayError(this, e);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean commit(Direction direction) {
        return this.commit(direction, true);
    }

    @Override
    public boolean commit(Direction direction, boolean closeAfterCommit) {
        return this.commit(direction, closeAfterCommit, false);
    }

    @Override
    public boolean commit(Direction direction, boolean closeAfterCommit, boolean skipValidation) {
        if (this.editHandler != null && !this.closed) {
            try {
                Object canonicalValue = this.getCanonicalValue();
                if (skipValidation || !skipValidation && this.validateCanonicalValue(canonicalValue)) {
                    boolean committed = this.editHandler.commit(canonicalValue, direction);
                    if (committed && closeAfterCommit) {
                        this.close();
                        if (direction != null && this.openAdjacentEditor()) {
                            this.layerCell.getLayer().doCommand(new EditSelectionCommand(this.parent, this.configRegistry));
                        }
                    }
                    return committed;
                }
            }
            catch (ConversionFailedException canonicalValue) {
            }
            catch (ValidationFailedException canonicalValue) {
            }
            catch (Exception e) {
                WaLTablePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.waltable.core", "Error on updating cell value: " + e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return false;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.parent != null && !this.parent.isDisposed()) {
            this.parent.forceFocus();
        }
        this.removeEditorControlListeners();
        Control editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed()) {
            editorControl.dispose();
        }
        ActiveCellEditorRegistry.unregisterActiveCellEditor();
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean openInline(ConfigRegistry configRegistry, List<String> configLabels) {
        return EditConfigHelper.openInline(configRegistry, configLabels);
    }

    @Override
    public boolean supportMultiEdit(ConfigRegistry configRegistry, List<String> configLabels) {
        return EditConfigHelper.supportMultiEdit(configRegistry, configLabels);
    }

    @Override
    public boolean openMultiEditDialog() {
        return true;
    }

    @Override
    public boolean openAdjacentEditor() {
        return EditConfigHelper.openAdjacentEditor(this.configRegistry, this.labelStack.getLabels());
    }

    @Override
    public boolean activateAtAnyPosition() {
        return true;
    }

    @Override
    public void addEditorControlListeners() {
        Control editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed() && this.editMode == EditMode.INLINE) {
            editorControl.addFocusListener(this.focusListener);
            editorControl.addTraverseListener(this.traverseListener);
        }
    }

    @Override
    public void removeEditorControlListeners() {
        Control editorControl = this.getEditorControl();
        if (editorControl != null && !editorControl.isDisposed()) {
            editorControl.removeFocusListener(this.focusListener);
            editorControl.removeTraverseListener(this.traverseListener);
        }
    }

    @Override
    public Rectangle calculateControlBounds(Rectangle cellBounds) {
        return cellBounds;
    }

    public void setDataValidator(IDataValidator validator) {
        this.dataValidator = validator;
    }

    private class InlineFocusListener
    extends FocusAdapter {
        private InlineFocusListener() {
        }

        public void focusLost(FocusEvent e) {
            if (!AbstractCellEditor.this.commit(null, true)) {
                if (e.widget instanceof Control && !e.widget.isDisposed()) {
                    ((Control)e.widget).forceFocus();
                }
            } else {
                AbstractCellEditor.this.parent.forceFocus();
            }
        }
    }

    private class InlineTraverseListener
    implements TraverseListener {
        private InlineTraverseListener() {
        }

        public void keyTraversed(TraverseEvent event) {
            boolean committed = false;
            if (event.keyCode == 9 && event.stateMask == SWT.MOD2) {
                committed = AbstractCellEditor.this.commit(Direction.LEFT);
            } else if (event.keyCode == 9 && event.stateMask == 0) {
                committed = AbstractCellEditor.this.commit(Direction.RIGHT);
            }
            if (!committed) {
                event.doit = false;
            }
        }
    }
}

