/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.core.eval;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.eclipse.statet.ecommons.debug.core.eval.IEvaluationResult;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class EvaluationWatchExpressionResult
implements IWatchExpressionResult {
    private static final String[] NO_MESSAGES = new String[0];
    private final IEvaluationResult result;

    public EvaluationWatchExpressionResult(IEvaluationResult result) {
        this.result = result;
        result.free();
    }

    public String getExpressionText() {
        return this.result.getExpressionText();
    }

    public boolean hasErrors() {
        return this.result.getStatus() == 4;
    }

    public @Nullable IValue getValue() {
        return this.result.getValue();
    }

    public String @Nullable [] getErrorMessages() {
        ImList<String> messages;
        if (this.result.getStatus() >= 4 && (messages = this.result.getMessages()) != null) {
            return (String[])messages.toArray((Object[])new String[messages.size()]);
        }
        return NO_MESSAGES;
    }

    public @Nullable DebugException getException() {
        return null;
    }

    public int hashCode() {
        return this.result.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EvaluationWatchExpressionResult) {
            return this.result.equals(((EvaluationWatchExpressionResult)obj).result);
        }
        return false;
    }

    public String toString() {
        return "EvaluationWatchExpressionResult= " + this.result.toString();
    }
}

