/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source;

import org.eclipse.jface.text.IRegion;
import org.eclipse.statet.ecommons.text.BasicHeuristicTokenScanner;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.rlang.RTokens;
import org.eclipse.statet.r.core.source.RChunkHeuristicTokenScanner;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;

@NonNullByDefault
public class RHeuristicTokenScanner
extends BasicHeuristicTokenScanner {
    public static final byte CURLY_BRACKET_TYPE = 0;
    public static final byte ROUND_BRACKET_TYPE = 1;
    public static final byte SQUARE_BRACKET_TYPE = 2;

    public static final byte getBracketType(char c) {
        switch (c) {
            case '{': 
            case '}': {
                return 0;
            }
            case '(': 
            case ')': {
                return 1;
            }
            case '[': 
            case ']': {
                return 2;
            }
        }
        throw new IllegalArgumentException();
    }

    public static final char getOpenBracket(byte bracketType) {
        switch (bracketType) {
            case 0: {
                return '{';
            }
            case 1: {
                return '(';
            }
            case 2: {
                return '[';
            }
        }
        throw new AssertionError();
    }

    public static final char getCloseBracket(byte bracketType) {
        switch (bracketType) {
            case 0: {
                return '}';
            }
            case 1: {
                return ')';
            }
            case 2: {
                return ']';
            }
        }
        throw new IllegalArgumentException();
    }

    public static RHeuristicTokenScanner create(DocContentSections documentContentInfo) {
        return documentContentInfo.getPrimaryType() == "org.eclipse.statet.R" ? new RHeuristicTokenScanner(documentContentInfo) : new RChunkHeuristicTokenScanner(documentContentInfo);
    }

    protected RHeuristicTokenScanner(DocContentSections documentContentInfo) {
        super(documentContentInfo, RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT);
    }

    public @Nullable IRegion findRWord(int position, final boolean isDotSeparator, boolean allowEnd) {
        return this.findRegion(position, new BasicHeuristicTokenScanner.StopCondition(this){

            public boolean stop() {
                return RTokens.isRobustSeparator(RHeuristicTokenScanner.this.ch, isDotSeparator);
            }
        }, true);
    }

    public int[] computeBracketBalance(int backwardOffset, int forwardOffset, int[] initial, int searchType) {
        int @NonNull [] compute = new int[3];
        BracketBalanceCondition condition = new BracketBalanceCondition();
        int breakType = -1;
        while (--backwardOffset >= 0) {
            if ((backwardOffset = this.scanBackward(backwardOffset, -1, (BasicHeuristicTokenScanner.StopCondition)condition)) == -1) break;
            if (condition.open) {
                int n = condition.type;
                compute[n] = compute[n] + 1;
                if (condition.type == searchType || compute[condition.type] <= 0) continue;
                breakType = condition.type;
                break;
            }
            int n = condition.type;
            compute[n] = compute[n] - 1;
        }
        int bound = this.getDocument().getLength();
        int i = 0;
        while (i < compute.length) {
            if (compute[i] < 0) {
                compute[i] = 0;
            }
            compute[i] = compute[i] + initial[i];
            ++i;
        }
        while (forwardOffset < bound) {
            if ((forwardOffset = this.scanForward(forwardOffset, bound, (BasicHeuristicTokenScanner.StopCondition)condition)) == -1) break;
            if (condition.open) {
                int n = condition.type;
                compute[n] = compute[n] + 1;
            } else {
                int n = condition.type;
                compute[n] = compute[n] - 1;
            }
            if ((condition.type == searchType || condition.type == breakType) && compute[condition.type] == 0) break;
            ++forwardOffset;
        }
        return compute;
    }

    private class BracketBalanceCondition
    extends BasicHeuristicTokenScanner.PartitionBasedCondition {
        private int type;
        private boolean open;

        private BracketBalanceCondition() {
            super((BasicHeuristicTokenScanner)RHeuristicTokenScanner.this);
        }

        protected boolean matchesChar() {
            switch (RHeuristicTokenScanner.this.ch) {
                case '{': {
                    this.type = 0;
                    this.open = true;
                    return true;
                }
                case '}': {
                    this.type = 0;
                    this.open = false;
                    return true;
                }
                case '(': {
                    this.type = 1;
                    this.open = true;
                    return true;
                }
                case ')': {
                    this.type = 1;
                    this.open = false;
                    return true;
                }
                case '[': {
                    this.type = 2;
                    this.open = true;
                    return true;
                }
                case ']': {
                    this.type = 2;
                    this.open = false;
                    return true;
                }
            }
            return false;
        }
    }
}

