/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.builder;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.statet.docmlet.tex.core.TexBuildParticipant;
import org.eclipse.statet.docmlet.tex.core.model.TexWorkspaceSourceUnit;
import org.eclipse.statet.docmlet.tex.core.model.build.LtxSourceUnitModelContainer;
import org.eclipse.statet.docmlet.tex.core.project.TexProject;
import org.eclipse.statet.internal.docmlet.tex.core.TexCorePlugin;
import org.eclipse.statet.internal.docmlet.tex.core.builder.TexProjectBuilder;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxReconciler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.project.core.builder.ProjectBuildTask;
import org.eclipse.statet.ltk.project.core.builder.ProjectTaskBuilder;

@NonNullByDefault
public class TexBuildTask
extends ProjectBuildTask<TexProject, TexWorkspaceSourceUnit, TexBuildParticipant> {
    private @Nullable LtxReconciler reconciler;

    public TexBuildTask(TexProjectBuilder builder) {
        super((ProjectTaskBuilder)builder);
    }

    private LtxReconciler getReconciler() {
        LtxReconciler reconciler = this.reconciler;
        if (reconciler == null) {
            reconciler = new LtxReconciler(TexCorePlugin.getInstance().getLtxModelManager());
            reconciler.init((TexProject)this.getBuilder().getLtkProject(), this.status);
            this.reconciler = reconciler;
        }
        return reconciler;
    }

    protected void reconcileSourceUnit(TexWorkspaceSourceUnit sourceUnit, SubMonitor m) {
        LtxSourceUnitModelContainer adapter = (LtxSourceUnitModelContainer)((Object)sourceUnit.getAdapter(LtxSourceUnitModelContainer.class));
        if (adapter != null) {
            this.clearSourceUnit(adapter);
            this.getReconciler().reconcile(adapter, 0x2000003, (IProgressMonitor)m);
        }
    }
}

