/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.TexCoreAccess;
import org.eclipse.statet.docmlet.tex.core.project.TexProject;
import org.eclipse.statet.docmlet.tex.core.project.TexProjects;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;

@NonNullByDefault
public class WorkspaceAdapterFactory
implements IAdapterFactory {
    private static final @NonNull Class<?>[] ADAPTERS = new Class[]{TexCoreAccess.class};

    public static TexCoreAccess getResourceCoreAccess(IResource resource) {
        TexProject texProject = TexProjects.getTexProject(resource.getProject());
        if (texProject != null) {
            return texProject;
        }
        return TexCore.getWorkbenchAccess();
    }

    public static @Nullable TexCoreAccess getResourceCoreAccess(@Nullable Object resource) {
        if (resource instanceof IResource) {
            return WorkspaceAdapterFactory.getResourceCoreAccess((IResource)resource);
        }
        return null;
    }

    public @NonNull Class<?>[] getAdapterList() {
        return ADAPTERS;
    }

    public <T> @Nullable T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adapterType == TexCoreAccess.class) {
            if (adaptableObject instanceof WorkspaceSourceUnit) {
                return (T)WorkspaceAdapterFactory.getResourceCoreAccess(((WorkspaceSourceUnit)adaptableObject).getResource());
            }
            if (adaptableObject instanceof IResource) {
                return (T)WorkspaceAdapterFactory.getResourceCoreAccess((IResource)adaptableObject);
            }
            return (T)TexCore.getWorkbenchAccess();
        }
        return null;
    }
}

