/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.breakpoints;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.resources.core.util.MarkerUpdate;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.rmodel.RWorkspaceSourceUnit;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpoint;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpointValidator;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IMarkerUpdater;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class BreakpointMarkerUpdater
implements IMarkerUpdater {
    private static final String[] ATTRIBUTES = new String[]{"lineNumber", "charStart", "charEnd"};

    public String getMarkerType() {
        return IBreakpoint.BREAKPOINT_MARKER;
    }

    public String[] getAttribute() {
        return ATTRIBUTES;
    }

    public boolean updateMarker(IMarker marker, IDocument document, Position position) {
        if (position == null) {
            return true;
        }
        if (position.isDeleted()) {
            return false;
        }
        IBreakpoint breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
        if (breakpoint == null) {
            return false;
        }
        if (breakpoint instanceof RLineBreakpoint) {
            return this.update((RLineBreakpoint)breakpoint, marker, document, position);
        }
        return this.updateBasic(marker, document, position);
    }

    private boolean update(RLineBreakpoint breakpoint, IMarker marker, IDocument document, Position position) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        SourceUnitManager suManager = LtkModels.getSourceUnitManager();
        SourceUnit su = suManager.getSourceUnit(Ltk.PERSISTENCE_CONTEXT, (Object)marker.getResource(), null, true, (IProgressMonitor)monitor);
        if (su != null) {
            try {
                RWorkspaceSourceUnit rSourceUnit;
                RLineBreakpointValidator validator;
                su = suManager.getSourceUnit(Ltk.EDITOR_CONTEXT, (Object)su, null, true, (IProgressMonitor)monitor);
                assert (su.getDocument(null) == document);
                if (su instanceof RWorkspaceSourceUnit && (validator = new RLineBreakpointValidator(rSourceUnit = (RWorkspaceSourceUnit)su, breakpoint.getBreakpointType(), position.getOffset(), (IProgressMonitor)monitor)).getType() != null) {
                    validator.updateBreakpoint((RBreakpoint)breakpoint);
                    return true;
                }
                return false;
            }
            catch (CoreException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, NLS.bind((String)"An error occurred when updating an R line breakpoint in ''{0}''.", (Object)su.getElementName().getDisplayName()), (Throwable)e));
                return false;
            }
            finally {
                su.disconnect((IProgressMonitor)monitor);
            }
        }
        return false;
    }

    private boolean updateBasic(IMarker marker, IDocument document, Position position) {
        MarkerUpdate markerUpdate = new MarkerUpdate(marker, 3);
        boolean offsetsInitialized = false;
        int markerStart = MarkerUtilities.getCharStart((IMarker)marker);
        int markerEnd = MarkerUtilities.getCharEnd((IMarker)marker);
        if (markerStart != -1 && markerEnd != -1) {
            offsetsInitialized = true;
            int offset = position.getOffset();
            if (offset != markerStart) {
                markerUpdate.setAttribute("charStart", offset);
            }
            if ((offset += position.getLength()) != markerEnd) {
                markerUpdate.setAttribute("charEnd", offset);
            }
        }
        int markerLineNumber = MarkerUtilities.getLineNumber((IMarker)marker);
        if (!offsetsInitialized || markerLineNumber != -1) {
            try {
                int lineNumber = document.getLineOfOffset(position.getOffset()) + 1;
                if (lineNumber != markerLineNumber) {
                    markerUpdate.setAttribute("lineNumber", lineNumber);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        try {
            markerUpdate.apply();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
        return true;
    }
}

