/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.core;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectAccess;
import org.eclipse.statet.ecommons.preferences.core.PreferenceObjectDef;
import org.eclipse.statet.internal.ecommons.preferences.core.ECommonsPreferencesCorePlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

@NonNullByDefault
public class PreferenceUtils {
    public static final int FLUSH_SYNC = 1;
    public static final int FLUSH_ASYNC = 2;
    private static final String MIGRATED_KEY = "migrated";

    public static <T> T getPrefValue(List<IScopeContext> contexts, Preference<T> pref) {
        String storeValue = null;
        int i = 0;
        while (i < contexts.size() && storeValue == null) {
            try {
                storeValue = contexts.get(i).getNode(pref.getQualifier()).get(pref.getKey(), null);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            ++i;
        }
        return pref.store2Usage(storeValue);
    }

    public static <T> T getPrefValue(IScopeContext context, Preference<T> pref) {
        IEclipsePreferences node = context.getNode(pref.getQualifier());
        return PreferenceUtils.getPrefValue(node, pref);
    }

    public static <T> T getPrefValue(IEclipsePreferences node, Preference<T> pref) {
        String storeValue = node.get(pref.getKey(), null);
        return pref.store2Usage(storeValue);
    }

    public static <T> void setPrefValue(IScopeContext context, Preference<T> pref, T value) {
        IEclipsePreferences node = context.getNode(pref.getQualifier());
        PreferenceUtils.setPrefValue(node, pref, value);
    }

    public static <T> void setPrefValue(IScopeContext context, Preference<T> pref, T value, int flags) {
        final IEclipsePreferences node = context.getNode(pref.getQualifier());
        PreferenceUtils.setPrefValue(node, pref, value);
        if ((flags & 1) != 0) {
            PreferenceUtils.flush((Preferences)node);
        } else if ((flags & 2) != 0) {
            Job job = new Job("Save Preferences"){

                protected IStatus run(IProgressMonitor monitor) {
                    PreferenceUtils.flush((Preferences)node);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.setUser(false);
            job.setPriority(20);
            job.schedule();
        }
    }

    private static void flush(Preferences node) {
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ECommonsPreferencesCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ecommons.preferences.core", "An error occurred when saving preferences.", (Throwable)e));
        }
    }

    public static void setPrefValues(IScopeContext context, Map<Preference<?>, Object> preferencesMap) {
        for (Map.Entry<Preference<?>, Object> pref : preferencesMap.entrySet()) {
            PreferenceUtils.setPrefValue(context, pref.getKey(), pref.getValue());
        }
    }

    public static <T> void setPrefValue(IEclipsePreferences node, Preference<T> pref, T value) {
        String storeValue;
        if (value == null || (storeValue = pref.usage2Store(value)) == null) {
            node.remove(pref.getKey());
            return;
        }
        node.put(pref.getKey(), storeValue);
    }

    public static <TObject> TObject getPreferenceObject(PreferenceAccess prefs, PreferenceObjectDef<TObject> def) {
        if (prefs instanceof PreferenceObjectAccess) {
            return ((PreferenceObjectAccess)((Object)prefs)).getPreferenceObject(def);
        }
        return def.create(prefs);
    }

    public static boolean mergeNode(String fromQualifier, String toQualifier, boolean deleteFinally) throws BackingStoreException {
        IScopeContext scope = InstanceScope.INSTANCE;
        if (!scope.getNode("").nodeExists(fromQualifier)) {
            return false;
        }
        IEclipsePreferences fromNode = scope.getNode(fromQualifier);
        if (!deleteFinally && fromNode.getBoolean(MIGRATED_KEY, false)) {
            return false;
        }
        IEclipsePreferences toNode = scope.getNode(toQualifier);
        String[] stringArray = fromNode.keys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            String key = stringArray[n2];
            if (!key.equals(MIGRATED_KEY) && (value = fromNode.get(key, null)) != null && toNode.get(key, null) == null) {
                toNode.put(key, value);
            }
            ++n2;
        }
        toNode.flush();
        if (deleteFinally) {
            Preferences parent = (Preferences)ObjectUtils.nonNullAssert((Object)fromNode.parent());
            fromNode.removeNode();
            parent.flush();
        } else {
            fromNode.putBoolean(MIGRATED_KEY, true);
            fromNode.flush();
        }
        return true;
    }

    private PreferenceUtils() {
    }
}

