/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.wikitext.ui;

import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.EmbeddingForeignElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.ui.ElementLabelProvider;
import org.eclipse.swt.graphics.Image;

@NonNullByDefault
public class WikitextElementLabelProvider
implements ElementLabelProvider {
    private final DocmlBaseUIResources docBaseResources = DocmlBaseUIResources.INSTANCE;

    protected Image getDocBaseImage(String imageId) {
        return this.docBaseResources.getImage(imageId);
    }

    public @Nullable Image getImage(LtkModelElement<?> element) {
        if (element.getModelTypeId() == "Wikidoc") {
            switch (element.getElementType() & 0xFFF) {
                case 1040: {
                    return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Preamble");
                }
                case 1057: {
                    return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H1");
                }
                case 1058: {
                    return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H2");
                }
                case 1059: {
                    return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H3");
                }
                case 1060: {
                    return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H4");
                }
                case 1061: {
                    return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H5");
                }
                case 1062: {
                    return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Sectioning-H6");
                }
                case 2048: {
                    SourceStructElement foreignElement = ((EmbeddingForeignElement)element).getForeignElement();
                    return foreignElement != null ? this.getEmbeddedForeignImage((LtkModelElement<?>)foreignElement) : null;
                }
            }
            return null;
        }
        return null;
    }

    protected @Nullable Image getEmbeddedForeignImage(LtkModelElement<?> element) {
        if (element.getModelTypeId() == "Yaml") {
            return this.getDocBaseImage("org.eclipse.statet.docmlet.base/image/obj/Preamble");
        }
        return null;
    }

    public @Nullable String getText(LtkModelElement<?> element) {
        if (element.getModelTypeId() == "Wikidoc") {
            return element.getElementName().getDisplayName();
        }
        return null;
    }
}

