/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.core;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.statet.jcommons.ts.core.Tool;

public class ToolPropertyTester
extends PropertyTester {
    public static final String IS_MAIN_TYPE = "isMainType";
    public static final String IS_PROVIDING_FEATURE = "isProvidingFeatureSet";
    public static final String IS_TERMINATED = "isTerminated";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        Tool tool = null;
        if (receiver instanceof Tool) {
            tool = (Tool)receiver;
        } else if (receiver instanceof IAdaptable) {
            tool = (Tool)((IAdaptable)receiver).getAdapter(Tool.class);
        }
        if (property.equals(IS_PROVIDING_FEATURE)) {
            if (tool == null) return false;
            if (!tool.isProvidingFeatureSet((String)expectedValue)) return false;
            return true;
        }
        if (property.equals(IS_MAIN_TYPE)) {
            if (tool == null) return false;
            if (!tool.getMainType().equals(expectedValue)) return false;
            return true;
        }
        if (!property.equals(IS_TERMINATED)) return false;
        if (Boolean.FALSE.equals(expectedValue)) {
            if (tool == null) return false;
            if (tool.isTerminated()) return false;
            return true;
        }
        if (tool == null) return false;
        if (!tool.isTerminated()) return false;
        if (args == null) return true;
        if (args.length == 0) {
            return true;
        }
        if (!(tool instanceof IProcess)) return false;
        IProcess process = (IProcess)tool;
        try {
            int exitValue = process.getExitValue();
            Object[] objectArray = args;
            int n = args.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Object arg = objectArray[n2];
                if (arg instanceof Integer && (Integer)arg == exitValue) {
                    return true;
                }
                ++n2;
            }
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        return false;
    }
}

