/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class HighlightBoundaryScanner
implements BoundaryScanner {
    private static final int MAX_SCAN = 10;

    public int findStartOffset(StringBuilder buffer, int start) {
        if (start > buffer.length() || start < 1) {
            return start;
        }
        int stop = Math.max(0, start - 10);
        int offset = start;
        while (offset > stop) {
            char c = buffer.charAt(offset - 1);
            if (c < ' ' || !Character.isLetterOrDigit(c)) {
                return offset;
            }
            --offset;
        }
        if (stop == 0) {
            return 0;
        }
        return start;
    }

    public int findEndOffset(StringBuilder buffer, int start) {
        if (start > buffer.length() || start < 0) {
            return start;
        }
        int stop = Math.min(buffer.length(), start + 10);
        int offset = start;
        while (offset < stop) {
            char c = buffer.charAt(offset);
            if (c < ' ' || !Character.isLetterOrDigit(c)) {
                return offset;
            }
            ++offset;
        }
        if (stop == buffer.length()) {
            return stop;
        }
        return start;
    }
}

