/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pager;

import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.statet.ecommons.text.ui.presentation.FixTokenScanner;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.internal.r.ui.pager.TextFilesTextStyleManager;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class TextFileSourceViewerConfiguration
extends SourceViewerConfiguration {
    private static final TextStyleManager<TextAttribute> TEXT_STYLE_MANAGER = new TextFilesTextStyleManager();
    private final TextStyleManager<TextAttribute> textStyles = TEXT_STYLE_MANAGER;
    private @Nullable IPresentationReconciler presentationReconciler;
    private final FixTokenScanner scanner = new FixTokenScanner(this.textStyles, "__dftl_partition_content_type");

    public void setStyleRegions(ImList<ITypedRegion> regions) {
        this.scanner.setStyleRegions(regions);
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        IPresentationReconciler presentationReconciler = this.presentationReconciler;
        if (presentationReconciler == null) {
            this.presentationReconciler = presentationReconciler = this.createPresentationReconciler();
        }
        return presentationReconciler;
    }

    protected IPresentationReconciler createPresentationReconciler() {
        PresentationReconciler reconciler = new PresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(null));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.scanner);
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }
}

