/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;

@NonNullByDefault
public abstract class Scalar
extends YamlAstNode {
    @Nullable String value;

    Scalar(YamlAstNode parent, int startOffset, int endOffset, @Nullable String value) {
        super(parent, startOffset, endOffset);
        this.value = value;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SCALAR;
    }

    public @Nullable String getText() {
        return this.value;
    }

    public boolean hasChildren() {
        return false;
    }

    public int getChildCount() {
        return 0;
    }

    @Override
    public YamlAstNode getChild(int index) {
        throw new IndexOutOfBoundsException();
    }

    public int getChildIndex(AstNode child) {
        return -1;
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
    }

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInYamlChildren(YamlAstVisitor visitor) throws InvocationTargetException {
    }

    static class DQuoted
    extends Scalar {
        DQuoted(YamlAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent, startOffset, endOffset, value);
        }

        @Override
        public char getOperator() {
            return '\"';
        }
    }

    static class Folded
    extends Scalar {
        Folded(YamlAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent, startOffset, endOffset, value);
        }

        @Override
        public char getOperator() {
            return '>';
        }
    }

    static class Literal
    extends Scalar {
        Literal(YamlAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent, startOffset, endOffset, value);
        }

        @Override
        public char getOperator() {
            return '|';
        }
    }

    static class Plain
    extends Scalar {
        Plain(YamlAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent, startOffset, endOffset, value);
        }

        Plain(YamlAstNode parent, int offset) {
            super(parent, offset, offset, null);
        }

        @Override
        public char getOperator() {
            return '\u0000';
        }
    }

    static class SQuoated
    extends Scalar {
        SQuoated(YamlAstNode parent, int startOffset, int endOffset, @Nullable String value) {
            super(parent, startOffset, endOffset, value);
        }

        @Override
        public char getOperator() {
            return '\'';
        }
    }
}

