/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.yaml.core.source.ast.NodeType;
import org.eclipse.statet.yaml.core.source.ast.Scalar;
import org.eclipse.statet.yaml.core.source.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.source.ast.YamlAstVisitor;
import org.eclipse.statet.yaml.core.source.ast.YamlAsts;

@NonNullByDefault
public class NodeWithProperties
extends YamlAstNode {
    ImIdentityList<YamlAstNode> properties = ImCollections.emptyIdentityList();
    YamlAstNode nodeChild;

    public NodeWithProperties(YamlAstNode parent, int startOffset, int endOffset) {
        super(parent, startOffset, endOffset);
    }

    @Override
    void finish(int endOffset) {
        boolean hasAnchor = false;
        boolean hasTag = false;
        for (YamlAstNode property : this.properties) {
            switch (property.getNodeType()) {
                case ANCHOR: {
                    if (!hasAnchor) {
                        hasAnchor = true;
                        break;
                    }
                    property.status = 0x400200;
                    break;
                }
                case TAG: {
                    if (!hasTag) {
                        hasTag = true;
                        break;
                    }
                    property.status = 0x400200;
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
        }
        if (this.nodeChild == null) {
            this.nodeChild = new Scalar.Plain(this, !this.properties.isEmpty() ? ((YamlAstNode)((Object)this.properties.get((int)(this.properties.size() - 1)))).endOffset : this.endOffset);
        } else if (this.nodeChild.status == 0) {
            switch (this.nodeChild.getNodeType()) {
                case ALIAS: {
                    if (!hasAnchor) break;
                    this.nodeChild.status = 0x400200;
                    break;
                }
            }
        }
        super.finish(endOffset);
        int minEnd = this.nodeChild.endOffset;
        if (this.endOffset < minEnd) {
            this.endOffset = minEnd;
        }
    }

    @Override
    protected boolean hasErrorInChild() {
        for (YamlAstNode property : this.properties) {
            if (!YamlAsts.hasErrors((AstNode)property)) continue;
            return true;
        }
        return YamlAsts.hasErrors((AstNode)this.nodeChild);
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.PROPERTIES_CONTAINER;
    }

    public boolean hasChildren() {
        return true;
    }

    public int getChildCount() {
        return this.properties.size() + 1;
    }

    public ImIdentityList<YamlAstNode> getProperties() {
        return this.properties;
    }

    public YamlAstNode getNode() {
        return this.nodeChild;
    }

    @Override
    public YamlAstNode getChild(int index) {
        if (index == this.properties.size()) {
            return this.nodeChild;
        }
        return (YamlAstNode)((Object)this.properties.get(index));
    }

    public int getChildIndex(AstNode child) {
        if (this.nodeChild == child) {
            return this.properties.size();
        }
        return this.properties.indexOf((Object)child);
    }

    public void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        for (YamlAstNode property : this.properties) {
            visitor.visit((AstNode)property);
        }
        visitor.visit((AstNode)this.nodeChild);
    }

    @Override
    public void acceptInYaml(YamlAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public void acceptInYamlChildren(YamlAstVisitor visitor) throws InvocationTargetException {
        for (YamlAstNode property : this.properties) {
            property.acceptInYaml(visitor);
        }
        this.nodeChild.acceptInYaml(visitor);
    }
}

