/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.console.ui.tools;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.preferences.core.PreferenceUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.console.ui.Messages;
import org.eclipse.statet.internal.r.console.ui.RConsoleUIPlugin;
import org.eclipse.statet.internal.r.console.ui.WorkbenchREnvIndexUpdater;
import org.eclipse.statet.jcommons.status.InfoStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolMessageDialog;
import org.eclipse.statet.r.console.core.AbstractRDataRunnable;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.pkgmanager.IRPkgChangeSet;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.launching.RRunDebugPreferenceConstants;
import org.eclipse.statet.r.nico.impl.RjsController;
import org.eclipse.statet.rhelp.core.REnvHelpConfiguration;
import org.eclipse.statet.rhelp.core.update.REnvIndexChecker;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvConfiguration;
import org.eclipse.statet.rj.renv.runtime.RPkgManager;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class REnvIndexAutoUpdater {
    public static void connect(RProcess process, IRPkgManager manager) {
        REnvConfiguration config = (REnvConfiguration)process.getAdapter(REnvConfiguration.class);
        if (config instanceof REnvHelpConfiguration && config.getStateSharedType() == "directory") {
            CheckRunnable checker = new CheckRunnable(process, (REnvHelpConfiguration)config, manager);
            process.getQueue().addOnIdle((SystemRunnable)checker, 1100);
            return;
        }
    }

    private static class AskDialog
    extends ToolMessageDialog {
        private Button rememberSessionControl;
        private Button rememberGloballyControl;
        private boolean rememberSession;
        private boolean rememberGlobally;

        public AskDialog(ToolProcess tool, String message) {
            super(tool, null, Messages.REnvIndex_CheckDialog_title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        }

        protected Control createMessageArea(Composite parent) {
            super.createMessageArea(parent);
            LayoutUtils.addGDDummy((Composite)parent);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 4, true, false));
            label.setText(Messages.REnvIndex_CheckDialog_Remember_label);
            Button button = new Button(composite, 32);
            GridData gd = new GridData(4, 4, true, false);
            gd.horizontalIndent = LayoutUtils.defaultIndent();
            button.setLayoutData((Object)gd);
            button.setText(Messages.REnvIndex_CheckDialog_RememberSession_label);
            this.rememberSessionControl = button;
            button = new Button(composite, 32);
            gd = new GridData(4, 4, true, false);
            gd.horizontalIndent = LayoutUtils.defaultIndent();
            button.setLayoutData((Object)gd);
            button.setText(Messages.REnvIndex_CheckDialog_RememberGlobally_label);
            this.rememberGloballyControl = button;
            this.rememberGloballyControl.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (rememberGloballyControl.getSelection()) {
                        rememberSessionControl.setSelection(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.rememberSessionControl.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    if (rememberSessionControl.getSelection()) {
                        rememberGloballyControl.setSelection(false);
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            return composite;
        }

        public boolean close() {
            this.rememberGlobally = this.rememberGloballyControl.getSelection();
            this.rememberSession = this.rememberSessionControl.getSelection();
            return super.close();
        }
    }

    private static class CheckRunnable
    implements SystemRunnable,
    IRPkgManager.Listener {
        private final RProcess process;
        private final REnvIndexChecker checker;
        private final IRPkgManager manager;
        private boolean changed;
        private String sessionSetting;

        public CheckRunnable(RProcess process, REnvHelpConfiguration config, IRPkgManager manager) {
            this.process = process;
            this.manager = manager;
            this.changed = true;
            this.checker = new REnvIndexChecker(config, RCore.getRHelpManager(), (RPkgManager)manager);
            this.manager.addListener((IRPkgManager.Listener)this);
        }

        public String getTypeId() {
            return "r/index/check";
        }

        public String getLabel() {
            return Messages.REnvIndex_Check_task;
        }

        public boolean canRunIn(Tool tool) {
            return tool.isProvidingFeatureSet("org.eclipse.statet.r.data");
        }

        public boolean changed(int event, Tool tool) {
            if (event == 289) {
                return false;
            }
            if (event == 290) {
                this.manager.removeListener((IRPkgManager.Listener)this);
            }
            return true;
        }

        public void handleChange(IRPkgManager.Event event) {
            IRPkgChangeSet changeSet;
            if ((event.pkgsChanged() & 1) != 0 && (changeSet = event.getInstalledPkgChangeSet()) != null && !changeSet.getNames().isEmpty()) {
                this.changed = true;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            RjsController r = (RjsController)service;
            if (r.isBusy()) return;
            if (!r.isDefaultPrompt()) return;
            if (!this.changed) {
                return;
            }
            this.changed = false;
            try {
                String message;
                String global = ((String)EPreferences.getInstancePrefs().getPreferenceValue((Preference)RRunDebugPreferenceConstants.PREF_RENV_CHECK_UPDATE)).intern();
                if (global == "no") return;
                if (global == "ask" && this.sessionSetting == "no") {
                    return;
                }
                int check = this.checker.check((RService)r, m);
                if (this.checker.wasAlreadyReported()) {
                    return;
                }
                switch (check) {
                    case -1: 
                    case 0: {
                        return;
                    }
                    case 2: {
                        message = NLS.bind((String)(this.checker.getNewPackageCount() + this.checker.getChangedPackageCount() == 1 ? Messages.REnvIndex_Check_Changed_singular_message : Messages.REnvIndex_Check_Changed_plural_message), (Object)this.checker.getNewPackageCount(), (Object)this.checker.getChangedPackageCount());
                        break;
                    }
                    case 1: {
                        message = Messages.REnvIndex_Check_NoIndex_message;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                if (global != "auto" && this.sessionSetting == null) {
                    final AtomicBoolean update = new AtomicBoolean();
                    UIAccess.getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            AskDialog dialog = new AskDialog((ToolProcess)process, message);
                            update.set(dialog.open() == 0);
                            if (dialog.rememberGlobally) {
                                PreferenceUtils.setPrefValue((IScopeContext)InstanceScope.INSTANCE, (Preference)RRunDebugPreferenceConstants.PREF_RENV_CHECK_UPDATE, (Object)(update.get() ? "auto" : "no"), (int)2);
                            } else if (dialog.rememberSession) {
                                sessionSetting = update.get() ? "auto" : "no";
                            }
                        }
                    });
                    if (!update.get()) {
                        return;
                    }
                }
                service.getTool().getQueue().add((ToolRunnable)new UpdateRunnable(check == 1));
                return;
            }
            catch (StatusException e) {
                if (e.getStatus().getSeverity() == 8) {
                    throw e;
                }
                RConsoleUIPlugin.logError(Messages.REnvIndex_Check_error_message, e);
                return;
            }
            finally {
                this.checker.release();
            }
        }
    }

    public static final class UpdateRunnable
    extends AbstractRDataRunnable {
        private final boolean completely;

        public UpdateRunnable(boolean completely) {
            super("r/index/update", Messages.REnvIndex_Update_task);
            this.completely = completely;
        }

        public boolean changed(int event, Tool tool) {
            return event != 289;
        }

        protected void run(IRDataAdapter r, ProgressMonitor m) throws StatusException {
            REnvConfiguration rEnvConfig = (REnvConfiguration)r.getTool().getAdapter(REnvConfiguration.class);
            if (rEnvConfig != null && (rEnvConfig = (REnvConfiguration)rEnvConfig.getREnv().get(REnvConfiguration.class)) != null) {
                String remoteAddress = r.getWorkspaceData().getRemoteAddress();
                HashMap<String, String> properties = new HashMap<String, String>();
                if (remoteAddress != null) {
                    properties.put("renv.hostname", remoteAddress);
                }
                IRPkgManager rPkgManager = RCore.getRPkgManager((REnv)rEnvConfig.getREnv());
                rPkgManager.check(0, (RService)r, m);
                r.handleStatus((Status)new InfoStatus("org.eclipse.statet.r.console.ui", Messages.REnvIndex_Update_Started_message), m);
                WorkbenchREnvIndexUpdater updater = new WorkbenchREnvIndexUpdater((REnvHelpConfiguration)rEnvConfig, RCore.getRHelpManager(), (RPkgManager)rPkgManager);
                Status status = updater.update((RService)r, this.completely, properties, m);
                r.handleStatus(status, m);
            }
        }
    }
}

