/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class EcoReconciler2
implements IReconciler {
    private final DocumentListener documentListener = new DocumentListener();
    private VisibleListener visibleListener;
    private ReconcileJob job;
    private int delay = 500;
    private IDocument document;
    private ITextViewer viewer;
    private SourceEditor editor;
    private volatile boolean isEditorVisible;
    private SourceUnit sourceUnit;
    private final CopyOnWriteIdentityListSet<StrategyEntry> strategies = new CopyOnWriteIdentityListSet();

    public EcoReconciler2() {
    }

    public EcoReconciler2(SourceEditor editor) {
        this.editor = editor;
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    protected IDocument getDocument() {
        return this.document;
    }

    protected ITextViewer getTextViewer() {
        return this.viewer;
    }

    protected boolean isEditorVisible() {
        return this.isEditorVisible;
    }

    public void install(ITextViewer textViewer) {
        Assert.isNotNull((Object)textViewer);
        this.viewer = textViewer;
        this.visibleListener = new VisibleListener();
        StyledText textWidget = this.viewer.getTextWidget();
        textWidget.addListener(22, (Listener)this.visibleListener);
        textWidget.addListener(23, (Listener)this.visibleListener);
        this.isEditorVisible = textWidget.isVisible();
        this.viewer.addTextInputListener((ITextInputListener)this.documentListener);
        this.connectDocument();
    }

    public void uninstall() {
        if (this.viewer != null) {
            this.disconnectDocument();
            this.viewer.removeTextInputListener((ITextInputListener)this.documentListener);
            this.viewer = null;
        }
    }

    protected void connectDocument() {
        IDocument document = this.viewer.getDocument();
        if (document == null || this.document == document) {
            return;
        }
        this.document = document;
        this.sourceUnit = this.editor.getSourceUnit();
        this.reconcilerDocumentChanged(this.document);
        this.job = new ReconcileJob(this.getInputName());
        this.document.addDocumentListener((IDocumentListener)this.documentListener);
        this.scheduleReconcile();
    }

    protected String getInputName() {
        if (this.sourceUnit != null) {
            return this.sourceUnit.getId();
        }
        return "-";
    }

    protected void reconcilerDocumentChanged(IDocument newDocument) {
    }

    protected void disconnectDocument() {
        if (this.document != null) {
            this.document.removeDocumentListener((IDocumentListener)this.documentListener);
            this.document = null;
            this.sourceUnit = null;
        }
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
    }

    private synchronized void scheduleReconcile() {
        if ((this.job.getState() & 3) == 0) {
            this.aboutToBeReconciled();
        }
        this.job.cancel();
        this.job.schedule(this.delay);
    }

    protected void aboutToBeReconciled() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processReconcile(IProgressMonitor monitor) {
        IDocument document = this.getDocument();
        SourceUnit input = this.sourceUnit;
        if (document == null || input == null) {
            return;
        }
        Region region = new Region(0, document.getLength());
        ImIdentityList<StrategyEntry> reconcilingStrategies = this.getReconcilingStrategies();
        for (StrategyEntry s : reconcilingStrategies) {
            IReconcilingStrategy iReconcilingStrategy = s.strategy;
            synchronized (iReconcilingStrategy) {
                if (s.suStrategy != null && input != null) {
                    s.suStrategy.setInput(input);
                } else {
                    s.strategy.setDocument(document);
                }
                if (!this.prepareStrategyReconcile(s)) {
                    continue;
                }
                if (monitor.isCanceled()) {
                    return;
                }
                if (s.strategyExtension != null) {
                    s.strategyExtension.setProgressMonitor(monitor);
                    if (!s.initialed) {
                        s.strategyExtension.initialReconcile();
                        s.initialed = true;
                        continue;
                    }
                }
                s.strategy.reconcile((IRegion)region);
            }
        }
    }

    protected boolean prepareStrategyReconcile(StrategyEntry s) {
        return true;
    }

    public void addReconcilingStrategy(IReconcilingStrategy strategy) {
        this.strategies.add((Object)new StrategyEntry(strategy));
    }

    protected ImIdentityList<StrategyEntry> getReconcilingStrategies() {
        return this.strategies.toList();
    }

    public IReconcilingStrategy getReconcilingStrategy(String contentType) {
        return null;
    }

    private class DocumentListener
    implements IDocumentListener,
    ITextInputListener {
        private DocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
        }

        public void documentChanged(DocumentEvent e) {
            EcoReconciler2.this.scheduleReconcile();
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
            if (EcoReconciler2.this.document != null && oldInput == EcoReconciler2.this.document && newInput != EcoReconciler2.this.document) {
                EcoReconciler2.this.disconnectDocument();
            }
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            EcoReconciler2.this.connectDocument();
        }
    }

    public static interface ISourceUnitStrategy {
        public void setInput(SourceUnit var1);
    }

    private class ReconcileJob
    extends Job
    implements ISchedulingRule {
        ReconcileJob(String name) {
            super("Reconciler '" + name + "'");
            this.setPriority(20);
            this.setRule(this);
            this.setSystem(true);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                EcoReconciler2.this.processReconcile(monitor);
            }
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }

    protected static class StrategyEntry {
        final IReconcilingStrategy strategy;
        final IReconcilingStrategyExtension strategyExtension;
        final ISourceUnitStrategy suStrategy;
        boolean initialed;

        StrategyEntry(IReconcilingStrategy strategy) {
            this.strategy = strategy;
            this.strategyExtension = strategy instanceof IReconcilingStrategyExtension ? (IReconcilingStrategyExtension)strategy : null;
            this.initialed = false;
            this.suStrategy = strategy instanceof ISourceUnitStrategy ? (ISourceUnitStrategy)strategy : null;
        }

        public int hashCode() {
            return this.strategy.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof StrategyEntry) {
                return ((StrategyEntry)obj).strategy == this.strategy;
            }
            return false;
        }
    }

    private class VisibleListener
    implements Listener {
        private VisibleListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 22: {
                    EcoReconciler2.this.isEditorVisible = true;
                    return;
                }
                case 23: {
                    EcoReconciler2.this.isEditorVisible = false;
                    return;
                }
            }
        }
    }
}

