/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Cursor;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Characters;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Code;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.Inline;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.SourceSpan;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class CodeSpan
extends SourceSpan {
    private static final Pattern OPEN_PATTERN = Pattern.compile("(`+).*", 32);
    private static final Pattern CLOSE_PATTERN = Pattern.compile("`+", 32);
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\n", 32);
    private @Nullable Matcher openMatcher;
    private @Nullable Matcher closeMatcher;
    private @Nullable Matcher lineBreakMatcher;

    @Override
    public @Nullable Inline createInline(ProcessingContext context, Cursor cursor) {
        Matcher openMatcher;
        char c = cursor.getChar();
        if (c == '`' && (openMatcher = cursor.setup(this.getOpenMatcher())).matches()) {
            int startOffset = cursor.getOffset();
            int backtickCount = openMatcher.end(1) - openMatcher.start(1);
            Matcher closeMatcher = cursor.setup(this.getCloseMatcher(), backtickCount);
            while (closeMatcher.find()) {
                if (closeMatcher.end() - closeMatcher.start() != backtickCount) continue;
                String codeText = this.getCodeText(cursor.getText(openMatcher.end(1), closeMatcher.start()));
                int cursorLength = closeMatcher.end() - openMatcher.regionStart();
                int endOffset = cursor.getMatcherOffset(closeMatcher.end());
                return new Code(cursor.getLineAtOffset(), startOffset, endOffset - startOffset, cursorLength, codeText);
            }
            if (backtickCount > 1) {
                return new Characters(cursor.getLineAtOffset(), startOffset, backtickCount, backtickCount, openMatcher.group(1));
            }
        }
        return null;
    }

    private Matcher getOpenMatcher() {
        Matcher matcher = this.openMatcher;
        if (matcher == null) {
            this.openMatcher = matcher = OPEN_PATTERN.matcher("");
        }
        return matcher;
    }

    private Matcher getCloseMatcher() {
        Matcher matcher = this.closeMatcher;
        if (matcher == null) {
            this.closeMatcher = matcher = CLOSE_PATTERN.matcher("");
        }
        return matcher;
    }

    private Matcher getLineBreakMatcher() {
        Matcher matcher = this.lineBreakMatcher;
        if (matcher == null) {
            this.lineBreakMatcher = matcher = LINE_BREAK_PATTERN.matcher("");
        }
        return matcher;
    }

    private String getCodeText(String text) {
        String codeText = this.getLineBreakMatcher().reset(text).replaceAll(" ");
        int l = codeText.length();
        if (l >= 3 && codeText.charAt(0) == ' ' && codeText.charAt(l - 1) == ' ') {
            return codeText.substring(1, l - 1);
        }
        return codeText;
    }
}

