/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.actions.AbstractSourceEditorHandler;
import org.eclipse.swt.widgets.Display;

@NonNullByDefault
public class SourceEditorOperationHandler
extends AbstractSourceEditorHandler {
    private final int textOperation;

    public SourceEditorOperationHandler(int textOperation) {
        this.textOperation = textOperation;
    }

    public SourceEditorOperationHandler(SourceEditor editor, int textOperation) {
        super(editor);
        this.textOperation = textOperation;
    }

    protected final int getTextOperation() {
        return this.textOperation;
    }

    protected @Nullable ITextOperationTarget getOperationTarget(SourceEditor editor) {
        ITextOperationTarget target = (ITextOperationTarget)editor.getAdapter(ITextOperationTarget.class);
        if (target == null) {
            target = editor.getViewer().getTextOperationTarget();
        }
        return target;
    }

    @Override
    public void setEnabled(@Nullable Object evaluationContext) {
        SourceEditor editor = this.getSourceEditor(evaluationContext);
        if (editor == null || !this.isSupported(editor)) {
            this.setBaseEnabled(false);
            return;
        }
        ITextOperationTarget operationTarget = this.getOperationTarget(editor);
        this.setBaseEnabled(operationTarget != null && operationTarget.canDoOperation(this.textOperation));
    }

    @Override
    public @Nullable Object execute(ExecutionEvent event) throws ExecutionException {
        SourceEditor editor = this.getSourceEditor(event.getApplicationContext());
        if (editor == null || !this.isSupported(editor)) {
            return null;
        }
        ITextOperationTarget operationTarget = this.getOperationTarget(editor);
        if (operationTarget != null && operationTarget.canDoOperation(this.textOperation)) {
            operationTarget.doOperation(this.textOperation);
            return null;
        }
        Display.getCurrent().beep();
        return null;
    }
}

