/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.core.builder.CompositeFrame;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.LtkModelUtils;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementFilter;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFrame;
import org.eclipse.statet.r.core.model.RLangElement;
import org.eclipse.statet.r.core.model.RSourceUnit;

@NonNullByDefault
public class RUnitElement
implements RLangElement<RLangElement<?>>,
Serializable {
    private static final long serialVersionUID = 2909953007129363256L;
    private transient SourceUnit sourceUnit;
    transient CompositeFrame envir;
    private List<RLangElement<?>> elements;

    public static RUnitElement read(RSourceUnit su, CompositeFrame envir, InputStream input) throws IOException, ClassNotFoundException {
        ObjectInputStream o = new ObjectInputStream(input);
        RUnitElement element = (RUnitElement)o.readObject();
        element.sourceUnit = su;
        element.envir = envir;
        return element;
    }

    public RUnitElement(RSourceUnit su, List<RLangElement> children) {
        this.sourceUnit = su;
        this.elements = Collections.unmodifiableList(children);
    }

    public RUnitElement() {
    }

    public String getModelTypeId() {
        return "R";
    }

    public int getElementType() {
        return 528;
    }

    @Override
    public RElementName getElementName() {
        ElementName elementName = this.sourceUnit.getElementName();
        if (elementName instanceof RElementName) {
            return (RElementName)elementName;
        }
        return RElementName.create(15, elementName.getSegmentName());
    }

    public String getId() {
        return this.sourceUnit.getId();
    }

    public boolean exists() {
        return true;
    }

    public boolean isReadOnly() {
        return this.sourceUnit.isReadOnly();
    }

    public SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public @Nullable RLangElement<?> getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(@Nullable LtkModelElementFilter<? super RLangElement<?>> filter) {
        return LtkModelUtils.hasChildren(this.elements, filter);
    }

    @Override
    public List<? extends RLangElement<?>> getModelChildren(@Nullable LtkModelElementFilter<? super RLangElement<?>> filter) {
        return LtkModelUtils.getChildren(this.elements, filter);
    }

    public <T> @Nullable T getAdapter(Class<T> adapterType) {
        if (adapterType == RFrame.class) {
            return (T)this.envir;
        }
        return null;
    }

    public void save(OutputStream outputStream) throws IOException {
        ObjectOutputStream o = new ObjectOutputStream(outputStream);
        o.writeObject(this);
        o.flush();
    }

    public @Nullable TextRegion getSourceRange() {
        return null;
    }

    public @Nullable TextRegion getNameSourceRange() {
        return null;
    }

    public @Nullable TextRegion getDocumentationRange() {
        return null;
    }
}

