/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.data.impl;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataFrame;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.impl.ExternalizableRObject;
import org.eclipse.statet.rj.data.impl.RDataResizeExtension;
import org.eclipse.statet.rj.data.impl.RList32Impl;
import org.eclipse.statet.rj.data.impl.RUniqueCharacter32Store;

@NonNullByDefault
public class RDataFrame32Impl
extends RList32Impl
implements RDataFrame,
ExternalizableRObject {
    private RStore<?> rownamesAttribute;
    private long rowCount;

    public RDataFrame32Impl(RObject[] columns, String className1, String[] initialNames, String[] initialRownames) {
        this(columns, className1, initialNames, initialRownames, true);
    }

    protected RDataFrame32Impl(RObject[] columns, String className1, String[] initialNames, String[] initialRownames, boolean check) {
        super(columns, className1, initialNames);
        if (columns.length == 0) {
            this.rowCount = 0L;
        } else {
            this.rowCount = columns[0].getLength();
            if (check) {
                int i = 0;
                while (i < columns.length) {
                    if (columns[i].getRObjectType() != 2 || columns[i].getLength() != this.rowCount) {
                        throw new IllegalArgumentException("Length of column " + i + ": " + columns[i].getLength());
                    }
                    ++i;
                }
            }
        }
        if (initialRownames != null && (long)initialRownames.length == this.rowCount) {
            this.rownamesAttribute = new RUniqueCharacter32Store(initialRownames);
            if (this.rownamesAttribute.getLength() != this.rowCount) {
                throw new IllegalArgumentException("Length of row names: " + this.rownamesAttribute.getLength());
            }
        }
    }

    public RDataFrame32Impl(RJIO io, RObjectFactory factory, int options) throws IOException {
        super(io, factory, options);
        this.rowCount = io.readLong();
        if ((options & 0x40) != 0) {
            this.rownamesAttribute = factory.readNames(io, this.rowCount);
        }
    }

    @Override
    public void writeExternal(RJIO io, RObjectFactory factory) throws IOException {
        int options = 0;
        if ((io.flags & 1) == 0 && this.rownamesAttribute != null) {
            options |= 0x40;
        }
        super.doWriteExternal(io, factory, options);
        io.writeLong(this.rowCount);
        if ((options & 0x40) != 0) {
            factory.writeNames(this.rownamesAttribute, io);
        }
    }

    @Override
    public byte getRObjectType() {
        return 6;
    }

    @Override
    protected String getDefaultRClassName() {
        return "data.frame";
    }

    @Override
    public long getColumnCount() {
        return this.getLength();
    }

    @Override
    public RCharacterStore getColumnNames() {
        return this.getNames();
    }

    public String getColumnName(int idx) {
        return this.getName(idx);
    }

    @Override
    public RStore<?> getColumn(int idx) {
        return this.get(idx).getData();
    }

    @Override
    public RStore<?> getColumn(long idx) {
        return this.get(idx).getData();
    }

    @Override
    public @Nullable RStore<?> getColumn(String name) {
        RObject obj = this.get(name);
        return obj != null ? obj.getData() : null;
    }

    @Override
    public boolean set(int idx, RObject component) {
        if (component == null) {
            throw new NullPointerException();
        }
        if (this.getLength() == 0L) {
            throw new IndexOutOfBoundsException(Long.toString(idx));
        }
        if (component.getRObjectType() != 2) {
            throw new IllegalArgumentException();
        }
        if (component.getLength() != this.rowCount) {
            throw new IllegalArgumentException();
        }
        return super.set(idx, component);
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public RStore<?> getRowNames() {
        return this.rownamesAttribute;
    }

    public void insertRow(int idx) {
        long length = this.getLength();
        int i = 0;
        while ((long)i < length) {
            ((RDataResizeExtension)((Object)this.get(i))).insertNA(idx);
            ++i;
        }
        ++this.rowCount;
    }

    public void removeRow(int idx) {
        long length = this.getLength();
        int i = 0;
        while ((long)i < length) {
            ((RDataResizeExtension)((Object)this.get(i))).remove(idx);
            ++i;
        }
        --this.rowCount;
    }
}

