/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.textile.core;

import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.MarkupParser;
import org.eclipse.mylyn.wikitext.parser.builder.MultiplexingDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.markup.AbstractMarkupLanguage;
import org.eclipse.mylyn.wikitext.parser.markup.Block;
import org.eclipse.mylyn.wikitext.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.textile.TextileLanguage;
import org.eclipse.statet.docmlet.wikitext.core.WikitextProblemReporter;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupConfig;
import org.eclipse.statet.docmlet.wikitext.core.markup.MarkupParser2;
import org.eclipse.statet.docmlet.wikitext.core.source.BlockWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupEventPrinter;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupSourceFormatAdapter;
import org.eclipse.statet.docmlet.wikitext.core.source.RegexBlockWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.RegexInlineWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.WeaveLanguageProcessor;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.ExtdocMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.TexMathDollarsDisplayWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.TexMathDollarsInlineWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.TexMathSBackslashDisplayWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.TexMathSBackslashInlineWeaveParticipant;
import org.eclipse.statet.docmlet.wikitext.core.source.extdoc.YamlBlockWeaveParticipant;
import org.eclipse.statet.internal.redocs.wikitext.r.textile.core.RChunkPartitionNodeScanner;
import org.eclipse.statet.internal.redocs.wikitext.r.textile.core.TextileValidator;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.redocs.r.core.source.AbstractRChunkPartitionNodeScanner;
import org.eclipse.statet.redocs.wikitext.r.core.source.RweaveMarkupLanguage;
import org.eclipse.statet.redocs.wikitext.r.textile.core.RTextileConfig;

public class RTextileLanguage
extends TextileLanguage
implements ExtdocMarkupLanguage,
RweaveMarkupLanguage {
    public static final String TEXTILE_LANGUAGE_NAME = "Textile";
    public static final String TEXTILE_RWEAVE_LANGUAGE_NAME = "Textile+R";
    private static final boolean DEBUG_LOG_BASE_EVENTS = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.statet.redocs.wikitext.r.textile/debug/Parser/logBaseEvents"));
    private static final ImList<String> INDENT_PREFIXES = ImCollections.emptyList();
    private static final Pattern CHUNK_START_LINE_PATTERN = Pattern.compile("\\A###\\.[ \\t]++(?:begin\\.rcode)(.*+)\\p{all}*\\z");
    private static final Pattern CHUNK_REF_LINE_PATTERN = Pattern.compile("\\A[ \\t]*<<(.*?)(?:>>)?+\\p{all}*\\z");
    private static final Pattern CHUNK_END_LINE_PATTERN = Pattern.compile("\\A###\\.[ \\t]++(?:end\\.rcode)\\p{all}*\\z");
    private static final Pattern INLINE_PATTERN = Pattern.compile("@r ([^@]+)@");
    private String scope;
    private int mode;
    private RTextileConfig config;
    private RTextileConfig configuredConfig;
    private WeaveLanguageProcessor weaveProcessor;
    private WikitextProblemReporter validator;
    private RChunkPartitionNodeScanner rPartitionScanner;

    public RTextileLanguage() {
        this(null, 0, null);
    }

    public RTextileLanguage(String scope, int mode, RTextileConfig config) {
        assert (TEXTILE_LANGUAGE_NAME.equals(this.getName()));
        this.setName(TEXTILE_RWEAVE_LANGUAGE_NAME);
        this.setExtendsLanguage(TEXTILE_LANGUAGE_NAME);
        this.scope = scope;
        this.mode = mode;
        this.setMarkupConfig(config);
    }

    public RTextileLanguage clone() {
        RTextileLanguage clone = (RTextileLanguage)super.clone();
        clone.mode = this.mode;
        clone.config = this.config;
        return clone;
    }

    public RTextileLanguage clone(String scope, int mode) {
        RTextileLanguage clone = (RTextileLanguage)super.clone();
        clone.scope = scope;
        clone.mode = mode;
        clone.config = this.config;
        return clone;
    }

    public String getScope() {
        return this.scope;
    }

    public int getMode() {
        return this.mode;
    }

    public boolean isModeEnabled(int modeMask) {
        return (this.mode & modeMask) != 0;
    }

    public void setMarkupConfig(MarkupConfig config) {
        if (config != null) {
            config.seal();
        }
        this.config = (RTextileConfig)config;
    }

    public RTextileConfig getMarkupConfig() {
        return this.config;
    }

    protected void addPhraseModifierExtensions(AbstractMarkupLanguage.PatternBasedSyntax phraseModifierSyntax) {
        super.addPhraseModifierExtensions(phraseModifierSyntax);
    }

    protected void addBlockExtensions(List<Block> blocks, List<Block> paragraphBreakingBlocks) {
        super.addBlockExtensions(blocks, paragraphBreakingBlocks);
    }

    protected void configure(WeaveLanguageProcessor weaveProcessor, RTextileConfig config) {
        weaveProcessor.addChunkParticipant((BlockWeaveParticipant)new RegexBlockWeaveParticipant("R", 1, CHUNK_START_LINE_PATTERN, CHUNK_END_LINE_PATTERN));
        weaveProcessor.addInlineParticipants(new RegexInlineWeaveParticipant("R", 2, INLINE_PATTERN));
        if (config != null) {
            if (config.isYamlMetadataEnabled()) {
                weaveProcessor.addChunkParticipant((BlockWeaveParticipant)new YamlBlockWeaveParticipant());
            }
            if (config.isTexMathDollarsEnabled()) {
                weaveProcessor.addInlineParticipants((RegexInlineWeaveParticipant)new TexMathDollarsDisplayWeaveParticipant(this.isModeEnabled(16)));
                weaveProcessor.addInlineParticipants((RegexInlineWeaveParticipant)new TexMathDollarsInlineWeaveParticipant(this.isModeEnabled(16)));
            }
            if (config.isTexMathSBackslashEnabled()) {
                weaveProcessor.addInlineParticipants((RegexInlineWeaveParticipant)new TexMathSBackslashDisplayWeaveParticipant());
                weaveProcessor.addInlineParticipants((RegexInlineWeaveParticipant)new TexMathSBackslashInlineWeaveParticipant());
            }
        }
    }

    public void processContent(MarkupParser2 parser, SourceContent content, boolean asDocument) {
        RTextileConfig config;
        if (parser == null) {
            throw new NullPointerException("parser");
        }
        if (content == null) {
            throw new NullPointerException("content");
        }
        if (parser.getBuilder() == null) {
            throw new NullPointerException("parser.builder");
        }
        if (this.weaveProcessor == null) {
            this.weaveProcessor = new WeaveLanguageProcessor();
        }
        if ((config = this.getMarkupConfig()) != this.configuredConfig) {
            this.weaveProcessor.clearConfig();
            this.configure(this.weaveProcessor, config);
            this.configuredConfig = config;
        }
        this.setFilterGenerativeContents(parser.isDisabled(256));
        this.setBlocksOnly(parser.isDisabled(16));
        String markupContent = this.weaveProcessor.preprocess(content, parser.getBuilder(), parser.getFlags());
        if (DEBUG_LOG_BASE_EVENTS) {
            StringWriter out = new StringWriter();
            try {
                MarkupEventPrinter printer = new MarkupEventPrinter(markupContent, (MarkupLanguage)this, (Writer)out);
                MarkupParser baseParser = new MarkupParser((MarkupLanguage)this, (DocumentBuilder)new MultiplexingDocumentBuilder(new DocumentBuilder[]{printer, this.weaveProcessor}));
                super.processContent(baseParser, markupContent, asDocument);
                this.weaveProcessor.finish();
                System.out.println(out.toString());
            }
            catch (Exception e) {
                System.out.println(out.toString());
                e.printStackTrace();
            }
        } else {
            MarkupParser baseParser = new MarkupParser((MarkupLanguage)this, (DocumentBuilder)this.weaveProcessor);
            super.processContent(baseParser, markupContent, asDocument);
            this.weaveProcessor.finish();
        }
    }

    public void processContent(MarkupParser parser, String markupContent, boolean asDocument) {
        this.processContent(new MarkupParser2(parser), new SourceContent(0L, markupContent), asDocument);
    }

    public List<String> getIndentPrefixes() {
        return INDENT_PREFIXES;
    }

    public Pattern getRChunkStartLinePattern() {
        return CHUNK_START_LINE_PATTERN;
    }

    public Pattern getRChunkRefLinePattern() {
        return CHUNK_REF_LINE_PATTERN;
    }

    public Pattern getRChunkEndLinePattern() {
        return CHUNK_END_LINE_PATTERN;
    }

    public int hashCode() {
        return this.getName().hashCode() + this.mode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        RTextileLanguage other = (RTextileLanguage)((Object)obj);
        return this.getName().equals(other.getName()) && this.mode == other.mode && Objects.equals(this.config, other.getMarkupConfig());
    }

    public WikitextProblemReporter getProblemReporter() {
        if (this.validator == null) {
            this.validator = new TextileValidator();
        }
        return this.validator;
    }

    public MarkupSourceFormatAdapter getSourceFormatAdapter() {
        return null;
    }

    public AbstractRChunkPartitionNodeScanner getRChunkPartitionScanner() {
        if (this.rPartitionScanner == null) {
            this.rPartitionScanner = new RChunkPartitionNodeScanner();
        }
        return this.rPartitionScanner;
    }
}

