/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.r.ui.processing;

import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperation;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolOperationContext;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingToolProcess;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.variables.core.VariableText2;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.redocs.r.Messages;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.nico.core.runtime.IRequireSynch;
import org.eclipse.statet.r.console.core.IRBasicAdapter;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.console.core.util.RCodeVariableText;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.redocs.r.ui.processing.RConsoleOperationContext;

public class RunRConsoleSnippetOperation
extends DocProcessingOperation {
    public static final String ID = "org.eclipse.statet.redocs.docProcessing.RunRConsoleSnippetOperation";
    public static final String R_SNIPPET_CODE_ATTR_NAME = "org.eclipse.statet.redocs.docProcessing.RunRConsoleSnippetOperation/RSnippet.code";
    private String rCodeSnippet;

    public String getId() {
        return ID;
    }

    public String getLabel() {
        return Messages.ProcessingOperation_RunRConsoleSnippet_label;
    }

    public void init(DocProcessingToolConfig.StepConfig stepConfig, Map<String, String> settings, SubMonitor m) throws CoreException {
        super.init(stepConfig, settings, m);
        String code = settings.get(R_SNIPPET_CODE_ATTR_NAME);
        if (code == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.r", Messages.ProcessingOperation_RunRConsoleSnippet_RCode_error_SpecMissing_message));
        }
        try {
            this.getStepConfig().getVariableResolver().validate(code, VariableText2.Severities.CHECK_SYNTAX, null);
        }
        catch (CoreException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.r", NLS.bind((String)Messages.ProcessingOperation_RunRConsoleSnippet_RCode_error_SpecInvalid_message, (Object)e.getMessage())));
        }
        this.rCodeSnippet = code;
    }

    public String getContextId() {
        return "RConsole";
    }

    public DocProcessingToolOperationContext createContext() {
        return new RConsoleOperationContext();
    }

    public IStatus run(DocProcessingToolProcess toolProcess, SubMonitor m) throws CoreException {
        RConsoleOperationContext context = (RConsoleOperationContext)toolProcess.getCurrentOperationContext();
        IRBasicAdapter r = context.getRService();
        ProgressMonitor rMonitor = context.getRMonitor();
        try {
            m.beginTask(NLS.bind((String)Messages.ProcessingOperation_RunRConsoleSnippet_label, (Object)r.getTool().getLabel()), 10);
            r.briefAboutToChange();
            RWorkspace rWorkspace = r.getWorkspaceData();
            RCodeVariableText variableResolver = new RCodeVariableText(rWorkspace, this.getStepConfig().getVariableResolver().getExtraVariables());
            IFileStore dir = FileUtil.getFileStore((String)VariableUtils.getValue((IStringVariable)variableResolver.getVariable("wd_loc")));
            IFileStore currentDir = rWorkspace.getWorkspaceDir();
            if (!dir.equals(currentDir)) {
                String command = variableResolver.performStringSubstitution("setwd(\"${wd_loc}\")", null);
                r.submitToConsole(command, rMonitor);
                r.refreshWorkspaceData(0, rMonitor);
                currentDir = rWorkspace.getWorkspaceDir();
                if (!dir.equals(currentDir)) {
                    toolProcess.check((IStatus)new Status(4, "org.eclipse.statet.redocs.r", NLS.bind((String)Messages.ProcessingOperation_RunRConsoleSnippet_error_SetWdFailed_message, (Object)dir.toString(), (Object)(currentDir != null ? currentDir.toString() : "<missing>"))));
                }
            }
            try {
                String code;
                try {
                    code = variableResolver.performStringSubstitution(this.rCodeSnippet, null);
                }
                catch (CoreException e) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.redocs.r", NLS.bind((String)Messages.ProcessingOperation_RunRConsoleSnippet_RCode_error_SpecInvalid_message, (Object)e.getMessage())));
                }
                String[] codeLines = RUtil.LINE_SEPARATOR_PATTERN.split(code);
                int i = 0;
                while (i < codeLines.length) {
                    r.submitToConsole(codeLines[i], rMonitor);
                    ++i;
                }
                if (r instanceof IRequireSynch) {
                    ((IRequireSynch)r).synch(rMonitor);
                }
            }
            finally {
                r.briefChanged(1);
            }
        }
        catch (StatusException e) {
            org.eclipse.statet.jcommons.status.Status status = e.getStatus();
            throw new CoreException((IStatus)new Status((int)status.getSeverity(), "org.eclipse.statet.redocs.r", (status.getSeverity() & 6) != 0 ? "An error occurred when running commands in R." : status.getMessage(), (Throwable)e));
        }
        return Status.OK_STATUS;
    }
}

