/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.statet.ecommons.text.core.FragmentDocument;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.internal.r.ui.editors.RContextInformationValidator;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistProcessor;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.source.RDocumentConstants;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.statet.r.ui.editors.RSourceEditor;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;

@NonNullByDefault
public class RContentAssistProcessor
extends ContentAssistProcessor {
    private final RHeuristicTokenScanner scanner;
    private int timeoutCounter;

    public RContentAssistProcessor(ContentAssist assistant, String partition, ContentAssistComputerRegistry registry, RSourceEditor editor) {
        super(assistant, partition, registry, (SourceEditor)editor);
        this.scanner = RHeuristicTokenScanner.create((DocContentSections)editor.getDocumentContentInfo());
    }

    protected RSourceEditor getEditor() {
        return (RSourceEditor)super.getEditor();
    }

    protected AssistInvocationContext createCompletionProposalContext(int offset, IProgressMonitor monitor) {
        return new Context(offset, true, monitor);
    }

    protected AssistInvocationContext createContextInformationContext(int offset, IProgressMonitor monitor) {
        Context context;
        if (this.timeoutCounter <= 3) {
            long startTime = System.nanoTime();
            context = new Context(offset, true, monitor);
            this.timeoutCounter = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime) > 50L ? Math.min(this.timeoutCounter + 1, 10) : Math.max(this.timeoutCounter - 1, 0);
        } else {
            context = new Context(offset, false, monitor);
        }
        return context;
    }

    protected IContextInformationValidator createContextInformationValidator() {
        return new RContextInformationValidator(this.getEditor());
    }

    protected boolean forceContextInformation(AssistInvocationContext context) {
        IDocument document;
        int offset;
        block7: {
            block6: {
                offset = context.getInvocationOffset();
                if (context.getIdentifierPrefix().length() <= 0 && this.scanner != null) break block6;
                return false;
            }
            document = context.getSourceViewer().getDocument();
            if (document instanceof FragmentDocument) {
                FragmentDocument inputDoc = (FragmentDocument)document;
                document = inputDoc.getMasterDocument();
                offset += inputDoc.getOffsetInMasterDocument();
            }
            if (offset >= 2) break block7;
            return false;
        }
        try {
            char c;
            this.scanner.configure(document, RDocumentConstants.R_NO_COMMENT_CONTENT_CONSTRAINT);
            int previousOffset = this.scanner.findNonBlankBackward(offset, -2, true);
            if (previousOffset > 0 && ((c = document.getChar(previousOffset)) == '(' || c == ',')) {
                String partitionType = this.scanner.getPartition(previousOffset).getType();
                return RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT.matches(partitionType);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return false;
    }

    private class Context
    extends RAssistInvocationContext {
        public Context(int offset, boolean isProposal, IProgressMonitor monitor) {
            super(RContentAssistProcessor.this.getEditor(), offset, RContentAssistProcessor.this.getContentType(), isProposal, RContentAssistProcessor.this.scanner, monitor);
        }

        @Override
        protected int getToolReferencesWaitTimeout() {
            return RContentAssistProcessor.this.getAssistant().isCompletionProposalAutoRequest() ? 100 : 250;
        }

        @Override
        protected void toolReferencesResolved(ImList<CombinedRElement> resolvedElements) {
            RContentAssistProcessor.this.reloadPossibleCompletions(this);
        }
    }
}

