/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.ecommons.waltable.data.IDataProvider;
import org.eclipse.statet.ecommons.waltable.data.ISpanningDataProvider;
import org.eclipse.statet.ecommons.waltable.layer.cell.DataCell;
import org.eclipse.statet.ecommons.waltable.sort.ISortModel;
import org.eclipse.statet.internal.r.ui.dataeditor.ContentDescription;
import org.eclipse.statet.internal.r.ui.dataeditor.FTableVariable;
import org.eclipse.statet.internal.r.ui.dataeditor.RMatrixDataProvider;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.r.ui.dataeditor.RDataTableInput;
import org.eclipse.statet.r.ui.dataeditor.RDataTableVariable;
import org.eclipse.statet.rj.data.RArray;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RToolService;

public class FTableDataProvider
extends RMatrixDataProvider {
    private RList fColVars;
    private RList fRowVars;

    public FTableDataProvider(RDataTableInput input, RArray<?> struct) throws CoreException {
        super(input, struct);
    }

    @Override
    protected ContentDescription loadDescription(RElementName name, RArray<?> struct, RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        RDataTableColumn template = this.createColumn(struct.getData(), this.getInput().getFullName(), null, -1L, null, r, m);
        FunctionCall call = r.createFunctionCall("attr");
        call.add(this.getInput().getFullName());
        call.addChar("col.vars");
        this.fColVars = RDataUtils.checkRList((RObject)call.evalData(m));
        if (this.checkVars(this.fColVars) != this.getColumnCount()) {
            this.fColVars = null;
            throw new UnexpectedRDataException("col.vars");
        }
        call = r.createFunctionCall("attr");
        call.add(this.getInput().getFullName());
        call.addChar("row.vars");
        this.fRowVars = RDataUtils.checkRList((RObject)call.evalData(m));
        if (this.checkVars(this.fRowVars) != this.getFullRowCount()) {
            this.fColVars = null;
            this.fRowVars = null;
            throw new UnexpectedRDataException("row.vars");
        }
        int cols = (int)this.fColVars.getLength();
        int rows = (int)this.fRowVars.getLength();
        @NonNull RDataTableVariable[] variables = new RDataTableVariable[cols + rows];
        int i = 0;
        int j = 0;
        while (j < cols) {
            variables[i++] = new FTableVariable(1, this.fColVars.getName(j), this.fColVars.get(j).getData());
            ++j;
        }
        j = 0;
        while (j < rows) {
            variables[i++] = new FTableVariable(2, this.fRowVars.getName(j), this.fRowVars.get(j).getData());
            ++j;
        }
        return new ContentDescription(name, (RObject)struct, r.getTool(), (ImList<RDataTableColumn>)ImCollections.emptyList(), (ImList<RDataTableColumn>)ImCollections.emptyList(), (ImList<RDataTableColumn>)ImCollections.emptyList(), variables, template.getDefaultFormat());
    }

    private long checkVars(RList rList) {
        long num = 1L;
        int l = (int)rList.getLength();
        int i = 0;
        while (i < l) {
            num *= rList.get(i).getLength();
            ++i;
        }
        return num;
    }

    @Override
    protected ISortModel createSortModel() {
        return null;
    }

    @Override
    public boolean hasRealColumns() {
        return this.fColVars.getLength() > 0L;
    }

    @Override
    public boolean hasRealRows() {
        return this.fRowVars.getLength() > 0L;
    }

    @Override
    protected IDataProvider createColumnDataProvider() {
        return new FTableColumnDataProvider();
    }

    @Override
    protected IDataProvider createRowDataProvider() {
        return new FTableRowDataProvider();
    }

    @Override
    public IDataProvider createColumnLabelProvider() {
        return new IDataProvider(){

            public long getColumnCount() {
                return 0L;
            }

            public long getRowCount() {
                return FTableDataProvider.this.fColVars.getLength();
            }

            public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
                return FTableDataProvider.this.fColVars.getName(rowIndex);
            }

            public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public IDataProvider createRowLabelProvider() {
        return new IDataProvider(){

            public long getColumnCount() {
                return FTableDataProvider.this.fRowVars.getLength();
            }

            public long getRowCount() {
                return 0L;
            }

            public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
                return FTableDataProvider.this.fRowVars.getName(columnIndex);
            }

            public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
                throw new UnsupportedOperationException();
            }
        };
    }

    protected class FTableColumnDataProvider
    extends FTableHeaderDataProvider {
        public long getColumnCount() {
            return FTableDataProvider.this.getColumnCount();
        }

        public long getRowCount() {
            return FTableDataProvider.this.fColVars.getLength();
        }

        public DataCell getCellByPosition(long columnIndex, long rowIndex) {
            return this.getCell(FTableDataProvider.this.fColVars, rowIndex, columnIndex);
        }

        @Override
        protected DataCell createCell(long varIndex, long valueIndex, int valueSpan) {
            return new DataCell(valueIndex, varIndex, (long)valueSpan, 1L);
        }

        public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
            return this.getDataValue(FTableDataProvider.this.fColVars, rowIndex, columnIndex);
        }
    }

    protected abstract class FTableHeaderDataProvider
    implements ISpanningDataProvider {
        protected DataCell getCell(RList vars, long varIdx, long valueIdx) {
            int span = 1;
            long idx = vars.getLength() - 1L;
            while (idx > varIdx) {
                span = (int)((long)span * vars.get(idx).getLength());
                --idx;
            }
            valueIdx -= valueIdx % (long)span;
            return this.createCell(varIdx, valueIdx, span);
        }

        protected abstract DataCell createCell(long var1, long var3, int var5);

        protected Object getDataValue(RList vars, long varIdx, long valueIdx) {
            if (vars.getLength() == 0L) {
                return DUMMY;
            }
            int span = 1;
            long idx = vars.getLength() - 1L;
            while (idx > varIdx) {
                span = (int)((long)span * vars.get(idx).getLength());
                --idx;
            }
            RStore values = vars.get(varIdx).getData();
            valueIdx %= (long)span * values.getLength();
            return values.get(valueIdx /= (long)span);
        }

        public void setDataValue(long columnIndex, long rowIndex, Object newValue) {
            throw new UnsupportedOperationException();
        }
    }

    protected class FTableRowDataProvider
    extends FTableHeaderDataProvider {
        public long getColumnCount() {
            return FTableDataProvider.this.fRowVars.getLength();
        }

        public long getRowCount() {
            return FTableDataProvider.this.getRowCount();
        }

        public DataCell getCellByPosition(long columnIndex, long rowIndex) {
            return this.getCell(FTableDataProvider.this.fRowVars, columnIndex, rowIndex);
        }

        @Override
        protected DataCell createCell(long varPosition, long valuePosition, int valueSpan) {
            return new DataCell(varPosition, valuePosition, 1L, (long)valueSpan);
        }

        public Object getDataValue(long columnIndex, long rowIndex, int flags, IProgressMonitor monitor) {
            return this.getDataValue(FTableDataProvider.this.fRowVars, columnIndex, rowIndex);
        }
    }
}

