/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.refactoring;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.core.refactoring.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.model.core.ElementSet;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.refactoring.core.CommonRefactoringDescriptor;
import org.eclipse.statet.ltk.refactoring.core.RefactoringChange;
import org.eclipse.statet.ltk.refactoring.core.RefactoringMessages;
import org.eclipse.statet.ltk.refactoring.core.SourceUnitChange;
import org.eclipse.statet.ltk.refactoring.core.TextChangeCompatibility;
import org.eclipse.statet.r.core.RUtil;
import org.eclipse.statet.r.core.model.RElementAccess;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.rsource.ast.Assignment;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.rsource.ast.RAsts;
import org.eclipse.statet.r.core.source.RHeuristicTokenScanner;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class InlineTempRefactoring
extends Refactoring {
    private final RRefactoringAdapter adapter = new RRefactoringAdapter();
    private final ElementSet elementSet;
    private final @Nullable TextRegion selectionRegion;
    private final RSourceUnit sourceUnit;
    private @Nullable RAstNode symbolNode;
    private @Nullable ImList<? extends RElementAccess> accessList;
    private @Nullable Assignment assignmentNode;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$statet$r$core$rsource$ast$NodeType;

    public InlineTempRefactoring(RSourceUnit su, TextRegion region) {
        this.sourceUnit = su;
        this.elementSet = new ElementSet(new Object[]{su});
        this.selectionRegion = region != null && region.getStartOffset() >= 0 && region.getLength() >= 0 ? region : null;
    }

    public String getName() {
        return Messages.InlineTemp_label;
    }

    public String getIdentifier() {
        return "org.eclipse.statet.r.refactoring.InlineTempOperation";
    }

    public int getReferencesCount() {
        ImList<? extends RElementAccess> accessList = this.accessList;
        return accessList != null ? accessList.size() : -1;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)6);
        try {
            if (this.selectionRegion != null) {
                this.symbolNode = this.adapter.searchPotentialNameNode(this.sourceUnit, this.selectionRegion, true, (IProgressMonitor)m.newChild(4));
            }
            if (this.symbolNode == null) {
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)Messages.InlineTemp_error_InvalidSelection_message);
                return refactoringStatus;
            }
            RefactoringStatus result = new RefactoringStatus();
            this.adapter.checkInitialToModify(result, this.elementSet);
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            this.checkVariable(result);
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkVariable(RefactoringStatus result) {
        currentAccess = RElementAccess.getMainElementAccessOfNameNode(this.symbolNode);
        if (currentAccess == null) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)"Failed to detect variable information."));
            return;
        }
        if (currentAccess.getType() != 17 || currentAccess.getNextSegment() != null) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.InlineTemp_error_InvalidSelection_message));
            return;
        }
        frame = currentAccess.getFrame();
        if (frame != null && (frame.getFrameType() == 2 || frame.getFrameType() == 4)) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.InlineTemp_error_InvalidSelectionNotLocal_message));
            return;
        }
        allAccess = ImCollections.toIdentityList(currentAccess.getAllInUnit(false));
        writeAccess = null;
        idx = allAccess.indexOf((Object)currentAccess);
        if (idx >= 0) ** GOTO lbl22
        throw new IllegalStateException();
lbl-1000:
        // 1 sources

        {
            access = (RElementAccess)allAccess.get(idx);
            if (access.isWriteAccess()) {
                writeAccess = access;
                break;
            }
            --idx;
lbl22:
            // 2 sources

            ** while (idx >= 0)
        }
lbl23:
        // 2 sources

        if (writeAccess == null) {
            result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.InlineTemp_error_MissingDefinition_message));
            return;
        }
        writeAccessIdx = idx;
        node = writeAccess.getNode();
        switch (InlineTempRefactoring.$SWITCH_TABLE$org$eclipse$statet$r$core$rsource$ast$NodeType()[(node != null ? node.getNodeType() : NodeType.DUMMY).ordinal()]) {
            case 35: 
            case 36: 
            case 37: {
                break;
            }
            case 47: {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.InlineTemp_error_InvalidSelectionParameter_message));
                return;
            }
            default: {
                result.merge(RefactoringStatus.createFatalErrorStatus((String)Messages.InlineTemp_error_InvalidSelectionNoArrow_message));
                return;
            }
        }
        assignment = (Assignment)node;
        source = assignment.getSourceChild();
        if (RAsts.hasErrors(source)) {
            result.merge(RefactoringStatus.createWarningStatus((String)Messages.InlineTemp_warning_ValueSyntaxError_message));
        }
        idx = writeAccessIdx + 1;
        while (idx < allAccess.size()) {
            if (((RElementAccess)allAccess.get(idx)).isWriteAccess()) break;
            ++idx;
        }
        allAccessEnd = idx;
        this.accessList = ImCollections.toList((Collection)allAccess.subList(writeAccessIdx, allAccessEnd));
        this.assignmentNode = assignment;
    }

    public @Nullable String getVariableName() {
        ImList<? extends RElementAccess> accessList = this.accessList;
        if (accessList != null) {
            return ((RElementAccess)accessList.get(0)).getSegmentName();
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_FinalCheck_label, (int)3);
        try {
            RefactoringStatus status = new RefactoringStatus();
            this.adapter.checkFinalToModify(status, this.elementSet, (IProgressMonitor)m.newChild(2));
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            m.done();
        }
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (String)RefactoringMessages.Common_CreateChanges_label, (int)3);
        try {
            SourceUnitChange textFileChange = new SourceUnitChange((SourceUnit)this.sourceUnit);
            if (this.sourceUnit.getWorkingContext() == Ltk.EDITOR_CONTEXT) {
                textFileChange.setSaveMode(4);
            }
            this.createChanges((TextFileChange)textFileChange, m.newChild(2));
            HashMap arguments = new HashMap();
            String description = NLS.bind((String)Messages.InlineTemp_Descriptor_description, (Object)RUtil.formatVarName(this.getVariableName()));
            IProject resource = this.elementSet.getSingleProject();
            String project = resource != null ? resource.getName() : null;
            String source = project != null ? NLS.bind((String)RefactoringMessages.Common_Source_Project_label, (Object)project) : RefactoringMessages.Common_Source_Workspace_label;
            boolean flags = false;
            String comment = "";
            CommonRefactoringDescriptor descriptor = new CommonRefactoringDescriptor(this.getIdentifier(), project, description, "", arguments, 0);
            m.worked(1);
            RefactoringChange refactoringChange = new RefactoringChange((RefactoringDescriptor)descriptor, Messages.InlineTemp_label, new Change[]{textFileChange});
            return refactoringChange;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.core", "Unexpected error (concurrent change?)", (Throwable)e));
        }
        finally {
            m.done();
        }
    }

    private void createChanges(TextFileChange change, SubMonitor m) throws BadLocationException {
        m.setWorkRemaining(11);
        ImList accessList = (ImList)ObjectUtils.nonNullAssert(this.accessList);
        Assignment assignmentNode = (Assignment)((Object)ObjectUtils.nonNullAssert((Object)((Object)this.assignmentNode)));
        RAstNode value = assignmentNode.getSourceChild();
        this.sourceUnit.connect((IProgressMonitor)m.newChild(1));
        try {
            AbstractDocument doc = this.sourceUnit.getDocument((IProgressMonitor)m.newChild(1));
            String text = doc.get(value.getStartOffset(), value.getLength());
            String text2 = "(" + text + ")";
            RAstNode parent = assignmentNode.getRParent();
            if (parent.getNodeType() == NodeType.BLOCK || parent.getNodeType() == NodeType.SOURCELINES) {
                RHeuristicTokenScanner scanner = this.adapter.getScanner(this.sourceUnit);
                TextRegion assignmentRegion = this.adapter.expandWhitespaceBlock(doc, (TextRegion)assignmentNode, scanner);
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.InlineTemp_Changes_DeleteAssignment_name, (TextEdit)new DeleteEdit(assignmentRegion.getStartOffset(), assignmentRegion.getLength()));
                m.worked(4);
            } else {
                ReplaceEdit edit = new ReplaceEdit(assignmentNode.getStartOffset(), assignmentNode.getLength(), this.requireParentheses(assignmentNode, value) ? text2 : text);
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.InlineTemp_Changes_ReplaceAssignment_name, (TextEdit)edit);
                m.worked(4);
            }
            int i = 1;
            while (i < accessList.size()) {
                RAstNode node = ((RElementAccess)accessList.get(i)).getNode();
                ReplaceEdit edit = new ReplaceEdit(node.getStartOffset(), node.getLength(), this.requireParentheses(node, value) ? text2 : text);
                TextChangeCompatibility.addTextEdit((TextChange)change, (String)Messages.InlineTemp_Changes_ReplaceReference_name, (TextEdit)edit);
                ++i;
            }
            m.worked(4);
        }
        finally {
            this.sourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    private boolean requireParentheses(RAstNode oldValue, RAstNode newValue) {
        RAstNode parent = oldValue.getRParent();
        if (parent != null) {
            return parent.getNodeType().opPrec > 15 && parent.getNodeType().opPrec < newValue.getNodeType().opPrec;
        }
        return false;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$statet$r$core$rsource$ast$NodeType() {
        if ($SWITCH_TABLE$org$eclipse$statet$r$core$rsource$ast$NodeType != null) {
            return $SWITCH_TABLE$org$eclipse$statet$r$core$rsource$ast$NodeType;
        }
        int[] nArray = new int[NodeType.values().length];
        try {
            nArray[NodeType.ADD.ordinal()] = 28;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.AND.ordinal()] = 31;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.A_COLON.ordinal()] = 38;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.A_EQUALS.ordinal()] = 36;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.A_LEFT.ordinal()] = 37;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.A_RIGHT.ordinal()] = 35;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.BLOCK.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.COMMENT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.C_BREAK.ordinal()] = 44;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.C_FOR.ordinal()] = 40;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.C_IF.ordinal()] = 39;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.C_NEXT.ordinal()] = 43;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.C_REPEAT.ordinal()] = 42;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.C_WHILE.ordinal()] = 41;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.DOCU_AGGREGATION.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.DOCU_TAG.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.DOCU_TEXT.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.DUMMY.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.ERROR.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.ERROR_TERM.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.F_CALL.ordinal()] = 48;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.F_CALL_ARG.ordinal()] = 50;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.F_CALL_ARGS.ordinal()] = 49;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.F_DEF.ordinal()] = 45;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.F_DEF_ARG.ordinal()] = 47;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.F_DEF_ARGS.ordinal()] = 46;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.GROUP.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.HELP.ordinal()] = 51;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.MODEL.ordinal()] = 33;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.MULT.ordinal()] = 27;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.NOT.ordinal()] = 30;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.NS_GET.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.NS_GET_INT.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.NULL_CONST.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.NUM_CONST.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.OR.ordinal()] = 32;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.PIPE_FORWARD.ordinal()] = 34;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.POWER.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.RELATIONAL.ordinal()] = 29;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SEQ.ordinal()] = 25;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SIGN.ordinal()] = 24;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SOURCELINES.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SPECIAL.ordinal()] = 26;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.STRING_CONST.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SUB_INDEXED_ARG.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SUB_INDEXED_ARGS.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SUB_INDEXED_D.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SUB_INDEXED_S.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SUB_NAMED_PART.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SUB_NAMED_SLOT.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NodeType.SYMBOL.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$statet$r$core$rsource$ast$NodeType = nArray;
        return nArray;
    }
}

