/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.statet.ecommons.text.PartitionerDocumentSetupParticipant;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.DocumentModelProvider;
import org.eclipse.statet.ltk.model.core.LtkModels;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.WorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.sourceediting.SourceAnnotationModel;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.TextFileDocumentProvider;
import org.eclipse.ui.part.FileEditorInput;

@NonNullByDefault
public class SourceDocumentProvider<T extends SourceUnit>
extends TextFileDocumentProvider
implements DocumentModelProvider {
    private final String modelTypeId;
    private final @Nullable PartitionerDocumentSetupParticipant documentSetupParticipant;

    public SourceDocumentProvider(String modelTypeId, @Nullable PartitionerDocumentSetupParticipant documentSetupParticipant) {
        this.modelTypeId = (String)ObjectUtils.nonNullAssert((Object)modelTypeId);
        this.documentSetupParticipant = documentSetupParticipant;
    }

    protected TextFileDocumentProvider.FileInfo createEmptyFileInfo() {
        return new SourceFileInfo();
    }

    public void disconnect(Object element) {
        TextFileDocumentProvider.FileInfo info = this.getFileInfo(element);
        if (info instanceof SourceFileInfo) {
            SourceFileInfo rinfo = (SourceFileInfo)info;
            if (rinfo.fCount == 1 && rinfo.workingCopy != null) {
                SubMonitor m = SubMonitor.convert((IProgressMonitor)this.getProgressMonitor(), (int)1);
                try {
                    rinfo.workingCopy.disconnect((IProgressMonitor)m.newChild(1));
                }
                finally {
                    rinfo.workingCopy = null;
                    m.done();
                }
            }
        }
        super.disconnect(element);
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable TextFileDocumentProvider.FileInfo createFileInfo(Object element) throws CoreException {
        SourceFileInfo sourceInfo;
        block9: {
            TextFileDocumentProvider.FileInfo info = super.createFileInfo(element);
            if (!(info instanceof SourceFileInfo)) {
                return null;
            }
            IDocument document = this.getDocument(element);
            if (document instanceof AbstractDocument) {
                this.setupDocument((AbstractDocument)document);
            }
            IAdaptable adaptable = (IAdaptable)element;
            sourceInfo = (SourceFileInfo)info;
            SubMonitor m = SubMonitor.convert((IProgressMonitor)this.getProgressMonitor());
            try {
                IFileStore store;
                Object ifile = adaptable.getAdapter(IFile.class);
                SourceUnitManager suManager = LtkModels.getSourceUnitManager();
                if (ifile != null) {
                    m.setWorkRemaining(2);
                    SourceUnit pUnit = suManager.getSourceUnit(this.modelTypeId, Ltk.PERSISTENCE_CONTEXT, ifile, true, (IProgressMonitor)m.newChild(1));
                    sourceInfo.workingCopy = suManager.getSourceUnit(this.modelTypeId, Ltk.EDITOR_CONTEXT, (Object)pUnit, true, (IProgressMonitor)m.newChild(1));
                    break block9;
                }
                if (!(element instanceof IURIEditorInput)) break block9;
                m.setWorkRemaining(1);
                try {
                    store = EFS.getStore((URI)((IURIEditorInput)element).getURI());
                }
                catch (CoreException e) {
                    SourceFileInfo sourceFileInfo = sourceInfo;
                    m.done();
                    return sourceFileInfo;
                }
                sourceInfo.workingCopy = suManager.getSourceUnit(this.modelTypeId, Ltk.EDITOR_CONTEXT, (Object)store, true, (IProgressMonitor)m.newChild(1));
            }
            finally {
                m.done();
            }
        }
        return sourceInfo;
    }

    protected void setupDocument(AbstractDocument document) {
        if (this.documentSetupParticipant != null) {
            this.documentSetupParticipant.setup((IDocument)document);
        }
    }

    public @Nullable T getWorkingCopy(Object element) {
        TextFileDocumentProvider.FileInfo fileInfo = this.getFileInfo(element);
        if (fileInfo instanceof SourceFileInfo) {
            return (T)((SourceFileInfo)fileInfo).workingCopy;
        }
        return null;
    }

    public @Nullable IAnnotationModel getAnnotationModel(@Nullable Object element) {
        if (element instanceof WorkspaceSourceUnit) {
            element = new FileEditorInput((IFile)((WorkspaceSourceUnit)element).getResource());
        }
        return super.getAnnotationModel(element);
    }

    public @Nullable ProblemRequestor createProblemRequestor(SourceUnit element) {
        IAnnotationModel annotationModel = this.getAnnotationModel(element);
        if (annotationModel instanceof SourceAnnotationModel) {
            return ((SourceAnnotationModel)annotationModel).createProblemRequestor();
        }
        return null;
    }

    public static class SourceFileInfo
    extends TextFileDocumentProvider.FileInfo {
        private @Nullable SourceUnit workingCopy;
    }
}

