/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.jcommons.collections;

import java.util.stream.IntStream;
import org.eclipse.statet.internal.jcommons.collections.AbstractImIntList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ImIntSingletonList
extends AbstractImIntList {
    private final int e;

    public ImIntSingletonList(int e) {
        this.e = e;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(int element) {
        return this.e == element;
    }

    @Override
    public int getAt(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("index= " + index);
        }
        return this.e;
    }

    @Override
    public int indexOf(int element) {
        return this.e == element ? 0 : -1;
    }

    @Override
    public int lastIndexOf(int element) {
        return this.e == element ? 0 : -1;
    }

    @Override
    public IntStream stream() {
        return IntStream.of(this.e);
    }

    @Override
    public int[] toArray() {
        return new int[]{this.e};
    }

    public int hashCode() {
        int hashCode = 9;
        hashCode = 31 * hashCode + this.e;
        return hashCode;
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof IntList) {
            IntList other = (IntList)obj;
            return 1 == other.size() && this.e == other.getAt(0);
        }
        return false;
    }

    public String toString() {
        return "[" + this.e + ']';
    }
}

