/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Geometry;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class ToolPopup {
    private Shell shell;
    private CTabFolder tabFolder;
    private Button okButton;
    private Button cancelButton;
    private final List<ToolTab> toolTabs = new ArrayList<ToolTab>();
    private int ignoreActivation;
    private Color graphicBackgroundColor;

    protected void open(Shell parent, Rectangle position) {
        this.create(parent);
        Point size = this.shell.getSize();
        Display display = this.shell.getDisplay();
        Monitor monitor = DialogUtils.getClosestMonitor(display, position);
        Rectangle clientArea = monitor.getClientArea();
        Rectangle bounds = new Rectangle(position.x, position.y - size.y, size.x, size.y);
        if (bounds.y < 0) {
            bounds.y = position.y + position.height;
        }
        Geometry.moveInside((Rectangle)bounds, (Rectangle)clientArea);
        this.shell.setBounds(bounds);
        this.selectTab(this.getBestTab());
        this.shell.open();
    }

    public boolean isActive() {
        return UIAccess.isOkToUse((Control)this.shell) && this.shell.isVisible();
    }

    public void close() {
        if (UIAccess.isOkToUse((Control)this.shell)) {
            this.shell.close();
        }
        this.dispose();
    }

    public void dispose() {
        if (this.shell != null) {
            if (!this.shell.isDisposed()) {
                this.shell.dispose();
            }
            this.onDispose();
            this.shell = null;
        }
    }

    private void create(Shell parent) {
        if (UIAccess.isOkToUse((Control)this.shell)) {
            if (this.shell.getParent() == parent) {
                return;
            }
            this.dispose();
        }
        this.toolTabs.clear();
        this.shell = new Shell(parent, 16388);
        this.shell.setText("Color");
        this.shell.setFont(JFaceResources.getDialogFont());
        this.shell.setSize(320, 300);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.horizontalSpacing = 0;
        gl.verticalSpacing = 0;
        this.shell.setLayout((Layout)gl);
        SWTListener listener = new SWTListener();
        parent.addListener(12, (Listener)listener);
        this.shell.addListener(27, (Listener)listener);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(22));
        this.shell.setBackgroundMode(2);
        this.graphicBackgroundColor = this.shell.getDisplay().getSystemColor(15);
        this.tabFolder = new CTabFolder((Composite)this.shell, 0x800400);
        this.tabFolder.setSimple(true);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder.setSelectionBackground(this.graphicBackgroundColor);
        this.addTabs(this.tabFolder);
        Composite commonBar = new Composite((Composite)this.shell, 0);
        commonBar.setLayoutData((Object)new GridData(4, 4, true, false));
        commonBar.setLayout((Layout)LayoutUtils.newContentGrid(3));
        this.addStatusControls(commonBar);
        this.okButton = new Button(commonBar, 0x800008);
        this.okButton.setText(IDialogConstants.OK_LABEL);
        this.okButton.setFont(this.shell.getFont());
        this.okButton.addListener(13, (Listener)listener);
        this.cancelButton = new Button(commonBar, 0x800008);
        this.cancelButton.setText(IDialogConstants.CANCEL_LABEL);
        this.cancelButton.setFont(this.shell.getFont());
        this.cancelButton.addListener(13, (Listener)listener);
        Point size = this.okButton.computeSize(-1, -1, true);
        size.x = Math.max(size.x, this.cancelButton.computeSize((int)-1, (int)-1, (boolean)true).x);
        GridData gd = new GridData(4, 4);
        gd.widthHint = size.x;
        gd.heightHint = size.y - 2;
        this.okButton.setLayoutData((Object)gd);
        gd = new GridData(4, 4);
        gd.widthHint = size.x;
        gd.heightHint = size.y - 2;
        this.cancelButton.setLayoutData((Object)gd);
        this.tabFolder.addListener(13, (Listener)listener);
        this.shell.setDefaultButton(this.okButton);
        this.shell.pack();
    }

    public Shell getShell() {
        return this.shell;
    }

    public Color getGraphicBackgroundColor() {
        return this.graphicBackgroundColor;
    }

    protected CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    protected ToolTab getTab(String key) {
        for (ToolTab tab : this.toolTabs) {
            if (tab.key != key) continue;
            return tab;
        }
        return null;
    }

    protected ToolTab getTab(CTabItem item) {
        for (ToolTab tab : this.toolTabs) {
            if (tab.tabItem != item) continue;
            return tab;
        }
        return null;
    }

    protected void addStatusControls(Composite composite) {
    }

    protected void addTabs(CTabFolder tabFolder) {
    }

    protected ToolTab getBestTab() {
        return null;
    }

    protected void selectTab(ToolTab tab) {
        if (tab != null) {
            final CTabItem tabItem = tab.getTabItem();
            this.tabFolder.setSelection(tabItem);
            this.tabSelected(tab);
            final Display display = this.shell.getDisplay();
            final Control focusControl = display.getFocusControl();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (UIAccess.isOkToUse((Control)ToolPopup.this.tabFolder) && ToolPopup.this.tabFolder.getSelection() == tabItem && display.getFocusControl() == focusControl) {
                        tabItem.getControl().setFocus();
                    }
                }
            });
        }
    }

    protected void tabSelected(ToolTab tab) {
        if (tab != null) {
            tab.activated();
            tab.getTabItem().getControl().setFocus();
        }
    }

    public void beginIgnoreActivation() {
        ++this.ignoreActivation;
    }

    public void endIgnoreActivation() {
        --this.ignoreActivation;
    }

    protected void onDispose() {
        this.tabFolder = null;
        this.toolTabs.clear();
    }

    protected void onOK() {
    }

    protected static abstract class PreviewCanvas
    extends Canvas
    implements PaintListener {
        private static final int DEFAULT_WIDTH = 50;

        public PreviewCanvas(Composite parent) {
            super(parent, 0);
            this.addPaintListener(this);
            this.setLayoutData(this.createGD());
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            gc.setForeground(e.display.getSystemColor(16));
            Rectangle size = this.getClientArea();
            int width = Math.min(50, size.width / 2);
            int height = size.height - 7;
            int x0 = size.x;
            int y0 = size.y + (size.height - height) / 2;
            gc.drawRectangle(x0, y0, width, height);
            gc.drawRectangle(x0 + width, y0, width, height);
            this.drawPreview(gc, 0, x0 + 1, y0 + 1, width - 2, height - 2);
            this.drawPreview(gc, 1, x0 + width + 1, y0 + 1, width - 2, height - 2);
        }

        public GridData createGD() {
            return new GridData(4, 4, true, false);
        }

        public Point computeSize(int wHint, int hHint, boolean changed) {
            int width = 101;
            if (wHint != -1 && wHint < width) {
                width = Math.max(width / 2, wHint);
            }
            int height = hHint != -1 ? hHint : 4 + LayoutUtils.defaultHSpacing();
            return new Point(width, height);
        }

        protected abstract void drawPreview(GC var1, int var2, int var3, int var4, int var5, int var6);
    }

    private class SWTListener
    implements Listener {
        private SWTListener() {
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 27: {
                    if (ToolPopup.this.ignoreActivation == 0) {
                        ToolPopup.this.close();
                    }
                    return;
                }
                case 12: {
                    ToolPopup.this.dispose();
                    return;
                }
                case 13: {
                    if (event.widget == ToolPopup.this.okButton) {
                        ToolPopup.this.onOK();
                        ToolPopup.this.close();
                        return;
                    }
                    if (event.widget == ToolPopup.this.cancelButton) {
                        ToolPopup.this.close();
                        return;
                    }
                    if (event.widget != ToolPopup.this.tabFolder) break;
                    ToolPopup.this.tabSelected(ToolPopup.this.getTab(ToolPopup.this.tabFolder.getSelection()));
                    return;
                }
            }
        }
    }

    public static class ToolTab {
        private final String key;
        private final ToolPopup parent;
        private final CTabItem tabItem;
        private Composite composite;

        public ToolTab(String key, ToolPopup parent, String name, String tooltip) {
            this.key = key;
            this.parent = parent;
            this.tabItem = new CTabItem(parent.tabFolder, 0);
            this.tabItem.setText(name);
            this.tabItem.setToolTipText(tooltip);
            parent.toolTabs.add(this);
        }

        public ToolPopup getParent() {
            return this.parent;
        }

        public CTabItem getTabItem() {
            return this.tabItem;
        }

        protected Composite create() {
            Composite composite = new Composite((Composite)this.parent.getTabFolder(), 0);
            this.tabItem.setControl((Control)composite);
            composite.setBackground(this.getParent().getGraphicBackgroundColor());
            return composite;
        }

        protected void activated() {
        }

        protected void performOK() {
            this.parent.onOK();
            this.parent.close();
        }
    }
}

