/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.docmlet.base.ui.processing;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.statet.docmlet.base.ui.DocmlBaseUIResources;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfig;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigIOStepTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigMainTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingConfigStepTab;
import org.eclipse.statet.docmlet.base.ui.processing.DocProcessingOperationSettings;
import org.eclipse.statet.docmlet.base.ui.processing.operations.OpenUsingDocViewerOperationSettings;
import org.eclipse.statet.docmlet.base.ui.processing.operations.OpenUsingEclipseOperationSettings;
import org.eclipse.statet.docmlet.base.ui.processing.operations.RunExternalProgramOperationSettings;
import org.eclipse.statet.ecommons.databinding.core.observable.WritableEqualityValue;
import org.eclipse.statet.ecommons.resources.core.variables.ObservableResourcePathVariable;
import org.eclipse.statet.ecommons.resources.core.variables.ResourceVariableResolver;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.variables.core.VariableUtils;
import org.eclipse.statet.internal.docmlet.base.ui.processing.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

@NonNullByDefault
public class PreviewTab
extends DocProcessingConfigStepTab
implements DocProcessingConfigStepTab.Listener {
    private final DocProcessingConfigIOStepTab produceTab;
    private final IObservableValue<@Nullable DocProcessingConfig.Format> inputFormatValue;
    private final IObservableValue<@Nullable IFile> resolvedInputFileValue;
    private Label inputControl;

    public PreviewTab(DocProcessingConfigMainTab mainTab, DocProcessingConfigIOStepTab produceTab) {
        super(mainTab, "org.eclipse.statet.docmlet.base/preview");
        this.produceTab = produceTab;
        this.produceTab.addListener(this);
        Realm realm = this.getRealm();
        this.inputFormatValue = new WritableValue(realm, null, DocProcessingConfig.Format.class);
        this.inputFormatValue.addValueChangeListener((IValueChangeListener)this);
        this.resolvedInputFileValue = new WritableEqualityValue(realm, null, IFile.class);
        this.setAvailableOperations((List<DocProcessingOperationSettings>)ImCollections.newList((Object[])new DocProcessingOperationSettings[]{new OpenUsingEclipseOperationSettings(), new OpenUsingDocViewerOperationSettings(), new RunExternalProgramOperationSettings()}));
        produceTab.getOutputFileValue().addValueChangeListener((IValueChangeListener)this);
        this.changed(this.produceTab);
    }

    public Image getImage() {
        return DocmlBaseUIResources.INSTANCE.getImage("org.eclipse.statet.docmlet.base/image/tool/Preview");
    }

    public String getName() {
        return this.createName(Messages.PreviewTab_name);
    }

    @Override
    public String getLabel() {
        return Messages.Preview_label;
    }

    @Override
    protected void initVariables(Map<String, IStringVariable> variables) {
        variables.putAll(this.getMainTab().getSourceFileVariables());
        VariableUtils.add(variables, (IStringVariable)new ObservableResourcePathVariable((IStringVariable)DocProcessingConfig.IN_FILE_PATH_VAR, this.resolvedInputFileValue));
        VariableUtils.add(variables, (Collection)INPUT_RESOURCE_VAR_DEFS, (IDynamicVariableResolver)new ResourceVariableResolver(new ResourceVariableResolver.Context(){

            public @Nullable IResource getResource() {
                return (IResource)PreviewTab.this.resolvedInputFileValue.getValue();
            }
        }, 0));
    }

    protected void setInput(@Nullable DocProcessingConfig.Format format, @Nullable IFile file) {
        if (format != null && format.equals(this.inputFormatValue.getValue())) {
            this.resolvedInputFileValue.setValue((Object)file);
        } else if (file == null || !file.equals(this.resolvedInputFileValue.getValue())) {
            this.resolvedInputFileValue.setValue(null);
            this.inputFormatValue.setValue((Object)format);
            this.resolvedInputFileValue.setValue((Object)file);
        } else {
            this.inputFormatValue.setValue((Object)format);
        }
    }

    public @Nullable DocProcessingConfig.Format getInputFormat() {
        return (DocProcessingConfig.Format)this.inputFormatValue.getValue();
    }

    public @Nullable IFile getInputFile() {
        return (IFile)this.resolvedInputFileValue.getValue();
    }

    public IObservableValue<@Nullable IFile> getInputFileValue() {
        return this.resolvedInputFileValue;
    }

    @Override
    public String getInfo() {
        StringBuilder sb = this.getStringBuilder();
        DocProcessingConfig.Format inputFormat = this.getInputFormat();
        sb.append(inputFormat != null ? inputFormat.getInfoLabel() : "?");
        sb.append('\n');
        DocProcessingOperationSettings operation = this.getOperation();
        sb.append(operation != null ? operation.getInfo() : " ");
        return sb.toString();
    }

    @Override
    public void changed(DocProcessingConfigStepTab source) {
        if (source == this.produceTab) {
            this.updateInput();
        }
    }

    @Override
    public void handleValueChange(ValueChangeEvent<?> event) {
        if (event.getObservable() == this.produceTab.getOutputFileValue()) {
            this.updateInput();
            return;
        }
        if (event.getObservable() == this.inputFormatValue) {
            this.updateInputText();
        }
        super.handleValueChange(event);
    }

    private void updateInput() {
        DocProcessingConfig.Format format = this.produceTab.getOutputFormat();
        this.setInput(format != null ? DocProcessingConfig.createOutputFormat(format) : null, this.produceTab.getOutputFile());
    }

    @Override
    protected void addControls(Composite parent) {
        Composite composite = this.createFormatGroup(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, false));
        composite = this.createOperationGroup(parent);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    protected Composite createFormatGroup(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)4));
        group.setText("IO");
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText(Messages.StepTab_In_label);
        label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.inputControl = label;
        this.updateInputText();
        LayoutUtils.addSmallFiller((Composite)group, (boolean)false);
        return group;
    }

    @Override
    protected String getOperationsLabel() {
        return Messages.PreviewTab_Operations_label;
    }

    protected void updateInputText() {
        DocProcessingConfig.Format inputFormat = this.getInputFormat();
        if (!UIAccess.isOkToUse((Control)this.inputControl) || inputFormat == null) {
            return;
        }
        this.inputControl.setText(inputFormat.getInfoLabel());
        this.inputControl.getParent().layout(true);
    }

    @Override
    protected void addBindings(DataBindingContext dbc) {
        super.addBindings(dbc);
    }

    @Override
    protected String getDefaultOperationId() {
        return "org.eclipse.statet.docmlet.base.docProcessing.OpenUsingEclipseOperation";
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
    }

    @Override
    protected void doInitialize(ILaunchConfiguration configuration) {
        super.doInitialize(configuration);
    }

    @Override
    protected void doSave(ILaunchConfigurationWorkingCopy configuration) {
        super.doSave(configuration);
    }
}

