/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.statet.internal.r.ui.dataeditor.LoadDataException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.rj.services.util.dataaccess.LazyRStore;

@NonNullByDefault
abstract class Lock
extends ReentrantLock {
    static final int ERROR_STATE = 4;
    static final int RELOAD_STATE = 3;
    static final int PAUSE_STATE = 2;
    static final int LOCAL_PAUSE_STATE = 1;
    int state;
    protected final Condition requestor = this.newCondition();
    protected final Condition worker = this.newCondition();
    boolean scheduled;

    Lock() {
    }

    final boolean isReady() throws LoadDataException {
        if (this.state > 0) {
            switch (this.state) {
                case 1: 
                case 2: {
                    return false;
                }
                case 3: {
                    throw new LoadDataException(true);
                }
            }
            throw new LoadDataException(false);
        }
        return true;
    }

    final <T> // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable LazyRStore.Fragment<T> getFragment(LazyRStore<T> store, long rowIdx, long columnIdx, int flags, ProgressMonitor m) throws LoadDataException {
        this.lock();
        try {
            LazyRStore.Fragment fragment = this.isReady() ? store.getFragment(rowIdx, columnIdx, flags, m) : null;
            return fragment;
        }
        finally {
            this.unlock();
        }
    }

    void notifyWorker() {
        this.worker.signalAll();
    }

    void clear() {
        this.requestor.signalAll();
        this.worker.signalAll();
    }
}

