/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srv;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.server.srv.ServerControl;

@NonNullByDefault
public class CliUtil {
    public static final int EXIT_ARGS_MISSING = 131;
    public static final int EXIT_ARGS_INVALID = 130;
    private final String command;
    private final String name;
    private final Map<String, @Nullable String> options;

    public CliUtil(String[] args) {
        int idx = 0;
        if (args.length <= idx || args[idx].startsWith("-")) {
            this.invalidArgs("Missing server command");
        }
        this.command = args[idx++];
        if (!this.isValidCommand(this.command)) {
            this.invalidArgs("Invalid server command '" + this.command + "'");
        }
        if (this.isNameCommand(this.command) && args.length <= idx) {
            this.invalidArgs("Missing server name");
        }
        this.name = args[idx++];
        this.options = new HashMap<String, String>();
        while (idx < args.length) {
            String arg;
            if ((arg = args[idx++]).isEmpty() || arg.charAt(0) != '-') continue;
            int split = arg.indexOf(61);
            if (split > 1) {
                this.options.put(arg.substring(1, split), arg.substring(split + 1));
                continue;
            }
            if (split >= 0) continue;
            this.options.put(arg.substring(1), null);
        }
        this.checkGlobalOptions();
    }

    protected boolean isValidCommand(String command) {
        return command.equals("start") || command.equals("clean");
    }

    protected boolean isNameCommand(String command) {
        return true;
    }

    protected void checkGlobalOptions() {
        if (Boolean.parseBoolean(System.getProperty("org.eclipse.statet.rj.verbose")) || Boolean.parseBoolean(System.getProperty("org.eclipse.statet.rj.debug"))) {
            this.options.put("verbose", "true");
        }
        if (this.options.containsKey("log")) {
            try {
                String fileName = this.options.get("log");
                Path file = Path.of(fileName != null ? fileName : "out.log", new String[0]);
                PrintStream stream = new PrintStream(Files.newOutputStream(file, new OpenOption[0]), false, StandardCharsets.UTF_8);
                stream.println("RJ R engine log");
                stream.flush();
                System.setOut(stream);
                System.setErr(stream);
            }
            catch (Throwable e) {
                e.printStackTrace();
                ServerControl.exit(141);
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, @Nullable String> getOptions() {
        return this.options;
    }

    public void invalidArgs(String message) {
        System.err.println(message);
        this.printHelp();
        ServerControl.exit(130);
    }

    public void printHelp() {
        System.out.println("= Usage of RJserver command line control ================");
        System.out.println("commands:");
        System.out.println("  start <name>    adds server to RMIregistry");
        System.out.println("  clean <name>    stops server/remove from RMIregistry");
        System.out.println("name:             unique name in RMIregistry");
        System.out.println("options:");
        System.out.println("  -verbose        verbose logging");
        System.out.println("  -server         class name of server implementation");
        System.out.println("  -plugins=<..>   list of plugins");
        System.out.println("  -auth=<..>      authetification method");
    }
}

