/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.refactoring;

import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.refactoring.Messages;
import org.eclipse.statet.ltk.ui.refactoring.RefactoringBasedStatus;
import org.eclipse.statet.r.core.refactoring.RElementSearchProcessor;
import org.eclipse.statet.r.core.refactoring.RRefactoringAdapter;
import org.eclipse.statet.r.core.refactoring.RenameInWorkspaceRefactoring;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RenameInWorkspaceWizard
extends RefactoringWizard {
    public RenameInWorkspaceWizard(RenameInWorkspaceRefactoring ref) {
        super((Refactoring)ref, 100);
        this.setDefaultPageTitle(Messages.RenameInWorkspace_Wizard_title);
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new InputPage());
    }

    private static class InputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "RenameInWorkspace.InputPage";
        private Text variableNameControl;

        public InputPage() {
            super(PAGE_NAME);
        }

        protected RenameInWorkspaceRefactoring getRefactoring() {
            return (RenameInWorkspaceRefactoring)super.getRefactoring();
        }

        public void createControl(Composite parent) {
            Button button;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
            this.setControl((Control)composite);
            RenameInWorkspaceRefactoring refactoring = this.getRefactoring();
            String name = refactoring.getNewName();
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
            label.setText(NLS.bind((String)Messages.RenameInWorkspace_Wizard_header, (Object)RRefactoringAdapter.getQuotedIdentifier((String)name)));
            label.setFont(JFaceResources.getBannerFont());
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            label.setText(Messages.RenameInWorkspace_Wizard_VariableName_label);
            this.variableNameControl = new Text(composite, 2048);
            this.variableNameControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.variableNameControl.setFont(JFaceResources.getTextFont());
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            group.setText("Scope:");
            group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
            List modes = refactoring.getAvailableModes();
            if (modes.contains(RElementSearchProcessor.Mode.WORKSPACE)) {
                button = new Button((Composite)group, 16);
                button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                button.setText("&Workspace (complete project tree)");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getRefactoring().setMode(RElementSearchProcessor.Mode.WORKSPACE);
                    }
                });
                if (refactoring.getMode() == RElementSearchProcessor.Mode.WORKSPACE) {
                    button.setSelection(true);
                }
            }
            if (modes.contains(RElementSearchProcessor.Mode.CURRENT_AND_REFERENCING_PROJECTS)) {
                button = new Button((Composite)group, 16);
                button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                button.setText("Current and &referencing projects");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getRefactoring().setMode(RElementSearchProcessor.Mode.CURRENT_AND_REFERENCING_PROJECTS);
                    }
                });
                if (refactoring.getMode() == RElementSearchProcessor.Mode.CURRENT_AND_REFERENCING_PROJECTS) {
                    button.setSelection(true);
                }
            }
            if (modes.contains(RElementSearchProcessor.Mode.CURRENT_PROJECT)) {
                button = new Button((Composite)group, 16);
                button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                button.setText("C&urrent project");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getRefactoring().setMode(RElementSearchProcessor.Mode.CURRENT_PROJECT);
                    }
                });
                if (refactoring.getMode() == RElementSearchProcessor.Mode.CURRENT_PROJECT) {
                    button.setSelection(true);
                }
            }
            if (modes.contains(RElementSearchProcessor.Mode.CURRENT_FILE)) {
                button = new Button((Composite)group, 16);
                button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                button.setText("Current &file");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getRefactoring().setMode(RElementSearchProcessor.Mode.CURRENT_FILE);
                    }
                });
                if (refactoring.getMode() == RElementSearchProcessor.Mode.CURRENT_FILE) {
                    button.setSelection(true);
                }
            }
            if (modes.contains(RElementSearchProcessor.Mode.LOCAL_FRAME)) {
                button = new Button((Composite)group, 16);
                button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
                button.setText("&Local frame.");
                button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        this.getRefactoring().setMode(RElementSearchProcessor.Mode.LOCAL_FRAME);
                    }
                });
                if (refactoring.getMode() == RElementSearchProcessor.Mode.LOCAL_FRAME) {
                    button.setSelection(true);
                }
            }
            LayoutUtils.addSmallFiller((Composite)composite, (boolean)false);
            Dialog.applyDialogFont((Control)composite);
            this.initBindings();
            this.variableNameControl.selectAll();
        }

        protected void initBindings() {
            Realm realm = Realm.getDefault();
            DataBindingContext dbc = new DataBindingContext(realm);
            this.addBindings(dbc, realm);
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)dbc);
        }

        protected void addBindings(DataBindingContext dbc, Realm realm) {
            dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.variableNameControl), PojoProperties.value((String)"newName", String.class).observe((Object)this.getRefactoring()), new UpdateValueStrategy().setAfterGetValidator(text -> {
                RenameInWorkspaceRefactoring refactoring = this.getRefactoring();
                RefactoringStatus status = refactoring.checkNewName(text);
                if (status.isOK() && refactoring.getCurrentName().equals(text)) {
                    return Status.CANCEL_STATUS;
                }
                return new RefactoringBasedStatus(status);
            }), null);
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.variableNameControl.setFocus();
        }
    }
}

