/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import org.eclipse.statet.internal.r.ui.datafilter.Messages;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class TextSearchType {
    public static final TextSearchType ECLIPSE = new Eclipse();
    public static final TextSearchType REGEX = new Regex();
    public static final TextSearchType EXACT = new Exact();
    public static final ImList<TextSearchType> TYPES = ImCollections.newList((Object[])new TextSearchType[]{ECLIPSE, REGEX, EXACT});
    private final int id;
    private final String label;

    private TextSearchType(int id, String label) {
        this.id = id;
        this.label = label;
    }

    public int getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public abstract String getRPattern(String var1);

    public String toString() {
        return this.getClass().getName();
    }

    private static class Eclipse
    extends TextSearchType {
        private Eclipse() {
            super(0, Messages.TextSearch_Eclipse_label);
        }

        @Override
        public String getRPattern(String pattern) {
            if (pattern.length() == 0) {
                return pattern;
            }
            StringBuilder sb = new StringBuilder(pattern.length());
            int index = 0;
            if (pattern.charAt(0) == '*') {
                ++index;
            } else {
                sb.append('^');
            }
            block6: while (index < pattern.length()) {
                char c = pattern.charAt(index++);
                switch (c) {
                    case '\\': {
                        if (index >= pattern.length()) continue block6;
                        char c2 = pattern.charAt(index++);
                        sb.append('\\');
                        sb.append(c2);
                        break;
                    }
                    case '*': {
                        sb.append(".*");
                        break;
                    }
                    case '?': {
                        sb.append(".?");
                        break;
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case '^': 
                    case '{': 
                    case '|': {
                        sb.append('\\');
                        sb.append(c);
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }
    }

    private static class Exact
    extends TextSearchType {
        private Exact() {
            super(2, Messages.TextSearch_Exact_label);
        }

        @Override
        public String getRPattern(String pattern) {
            return pattern;
        }
    }

    private static class Regex
    extends TextSearchType {
        private Regex() {
            super(1, Messages.TextSearch_Regex_label);
        }

        @Override
        public String getRPattern(String pattern) {
            return pattern;
        }
    }
}

