/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.ltk.core.LtkCorePlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.core.IExtContentTypeManager;
import org.eclipse.statet.ltk.core.Ltk;
import org.eclipse.statet.ltk.core.WorkingContext;
import org.eclipse.statet.ltk.model.core.ModelTypeDescriptor;
import org.eclipse.statet.ltk.model.core.SourceUnitFactory;
import org.eclipse.statet.ltk.model.core.SourceUnitManager;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;

@NonNullByDefault
public class SourceUnitManagerImpl
implements SourceUnitManager,
Disposable {
    private static final String CONFIG_MODELTYPE_ID_ATTRIBUTE_NAME = "modelTypeId";
    private static final String CONFIG_CONTEXT_KEY_ATTRIBUTE_NAME = "contextKey";
    private final CleanupJob cleanupJob = new CleanupJob();
    private volatile ImList<ModelItem> modelItems = ImCollections.newList();
    private final IExtContentTypeManager contentManager = Ltk.getExtContentTypeManager();

    public SourceUnitManagerImpl() {
        this.cleanupJob.initialSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int performCleanup() {
        int count = 0;
        ImList<ModelItem> modelItems = this.modelItems;
        for (ModelItem modelItem : modelItems) {
            ImList<ContextItem> contextItems = modelItem.contextItems;
            for (ContextItem contextItem : contextItems) {
                SuItem suItem;
                while ((suItem = (SuItem)contextItem.susToClean.poll()) != null) {
                    HashMap<String, SuItem> hashMap = contextItem.sus;
                    synchronized (hashMap) {
                        if (contextItem.sus.get(suItem.getKey()) == suItem) {
                            contextItem.sus.remove(suItem.getKey());
                        }
                        suItem.dispose();
                        ++count;
                    }
                }
            }
        }
        return count;
    }

    public void dispose() {
        this.cleanupJob.dispose();
    }

    @Override
    public @Nullable SourceUnit getSourceUnit(String modelTypeId, WorkingContext context, Object from, boolean create, IProgressMonitor monitor) {
        if (modelTypeId == null) {
            throw new NullPointerException(CONFIG_MODELTYPE_ID_ATTRIBUTE_NAME);
        }
        if (context == null) {
            throw new NullPointerException("context");
        }
        return this.doGetSourceUnit(modelTypeId, context, from, create, monitor);
    }

    @Override
    public @Nullable SourceUnit getSourceUnit(WorkingContext context, Object from, @Nullable IContentType contentType, boolean create, IProgressMonitor monitor) {
        String modelTypeId;
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (from instanceof SourceUnit) {
            modelTypeId = ((SourceUnit)from).getModelTypeId();
        } else {
            if (contentType == null && (contentType = this.detectContentType(from)) == null) {
                return null;
            }
            ModelTypeDescriptor modelType = this.contentManager.getModelTypeForContentType(contentType.getId());
            if (modelType == null) {
                return null;
            }
            modelTypeId = modelType.getId();
        }
        return this.doGetSourceUnit(modelTypeId, context, from, create, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable SourceUnit doGetSourceUnit(String modelTypeId, WorkingContext context, Object from, boolean create, IProgressMonitor monitor) {
        SourceUnit su;
        SourceUnit fromUnit;
        block10: {
            block9: {
                String id;
                fromUnit = from instanceof SourceUnit ? (SourceUnit)from : null;
                ModelItem modelItem = this.getModelItem(modelTypeId);
                ContextItem contextItem = modelItem.getContextItem(context, create);
                su = null;
                if (contextItem == null) break block9;
                String string = id = fromUnit != null ? fromUnit.getId() : contextItem.factory.createId(from);
                if (id == null) break block10;
                ContextItem contextItem2 = contextItem;
                synchronized (contextItem2) {
                    SuItem suItem;
                    block8: {
                        block11: {
                            suItem = contextItem.sus.get(id);
                            if (suItem == null) break block11;
                            su = (SourceUnit)suItem.get();
                            if (suItem.isEnqueued()) {
                                su = null;
                            }
                            break block10;
                        }
                        if (!create) break block10;
                        su = contextItem.factory.createSourceUnit(id, from);
                        if (su != null && su.getModelTypeId().equals(modelItem.modelTypeId) && (su.getElementType() & 0xF00) == 512) break block8;
                        return null;
                    }
                    suItem = new SuItem(id, su, contextItem.susToClean);
                }
            }
            if (create) {
                throw new UnsupportedOperationException(NLS.bind((String)"Missing factory for model type ''{0}''.", (Object)modelTypeId));
            }
            return null;
        }
        if (su != null) {
            su.connect(monitor);
            if (fromUnit != null) {
                fromUnit.disconnect(monitor);
            }
            return su;
        }
        return null;
    }

    @Override
    public List<SourceUnit> getOpenSourceUnits(String modelTypeId, @Nullable WorkingContext context) {
        List<ModelItem> modelItems = this.getOpenModelItems(modelTypeId);
        if (modelItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SourceUnit> list = new ArrayList<SourceUnit>();
        int i = 0;
        while (i < modelItems.size()) {
            ImList<ContextItem> contextItems = modelItems.get(i).getOpenContextItems(context);
            if (!contextItems.isEmpty()) {
                for (ContextItem contextItem : contextItems) {
                    contextItem.appendOpenSus(list);
                }
            }
            ++i;
        }
        return list;
    }

    @Override
    public List<SourceUnit> getOpenSourceUnits(List<String> modelTypeIds, @Nullable WorkingContext context) {
        List<ModelItem> includedModelItems = this.getOpenModelItems(modelTypeIds);
        if (includedModelItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SourceUnit> list = new ArrayList<SourceUnit>(4);
        int i = 0;
        while (i < includedModelItems.size()) {
            ImList<ContextItem> contextItems = ((ModelItem)this.modelItems.get(i)).getOpenContextItems(context);
            if (!contextItems.isEmpty()) {
                for (ContextItem contextItem : contextItems) {
                    contextItem.appendOpenSus(list);
                }
            }
            ++i;
        }
        return list;
    }

    @Override
    public List<SourceUnit> getOpenSourceUnits(List<String> modelTypeIds, @Nullable WorkingContext context, Object from) {
        List<ModelItem> includedModelItems = this.getOpenModelItems(modelTypeIds);
        if (includedModelItems.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SourceUnit> list = new ArrayList<SourceUnit>(4);
        int i = 0;
        while (i < includedModelItems.size()) {
            ImList<ContextItem> contextItems = ((ModelItem)this.modelItems.get(i)).getOpenContextItems(context);
            if (!contextItems.isEmpty()) {
                for (ContextItem contextItem : contextItems) {
                    SourceUnit su = contextItem.getOpenSu(from);
                    if (su == null) continue;
                    list.add(su);
                }
            }
            ++i;
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private @Nullable IContentType detectContentType(Object from) {
        InputStream stream;
        block12: {
            IContentType iContentType;
            block11: {
                if (!(from instanceof IFile)) break block11;
                IFile file = (IFile)from;
                IContentDescription contentDescription = file.getContentDescription();
                if (contentDescription == null) return null;
                return contentDescription.getContentType();
            }
            if (!(from instanceof IFileStore)) return null;
            IFileStore file = (IFileStore)from;
            Throwable throwable = null;
            Object var4_8 = null;
            stream = file.openInputStream(0, null);
            try {
                IContentDescription contentDescription = Platform.getContentTypeManager().getDescriptionFor(stream, file.getName(), IContentDescription.ALL);
                if (contentDescription == null) break block12;
                iContentType = contentDescription.getContentType();
                if (stream == null) return iContentType;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (stream == null) throw throwable2;
                        stream.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        } else {
                            if (throwable == throwable3) throw throwable;
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | UnsupportedOperationException | CoreException e) {
                    LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", 0, "An error occurred when trying to detect content type of " + from, e));
                    return null;
                }
            }
            stream.close();
            return iContentType;
        }
        if (stream == null) return null;
        stream.close();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelItem getModelItem(String modelTypeId) {
        ImList<ModelItem> modelItems = this.modelItems;
        for (ModelItem modelItem : modelItems) {
            if (modelItem.modelTypeId != modelTypeId) continue;
            return modelItem;
        }
        SourceUnitManagerImpl sourceUnitManagerImpl = this;
        synchronized (sourceUnitManagerImpl) {
            if (modelItems != this.modelItems) {
                return this.getModelItem(modelTypeId);
            }
            ModelItem modelItem = new ModelItem(modelTypeId);
            this.modelItems = ImCollections.addElement(modelItems, (Object)modelItem);
            return modelItem;
        }
    }

    private List<ModelItem> getOpenModelItems(@Nullable String modelTypeId) {
        ImList<ModelItem> modelItems = this.modelItems;
        if (modelTypeId != null) {
            for (ModelItem modelItem : modelItems) {
                if (modelItem.modelTypeId != modelTypeId) continue;
                return ImCollections.newList((Object)modelItem);
            }
            return ImCollections.emptyList();
        }
        return modelItems;
    }

    private List<ModelItem> getOpenModelItems(@Nullable List<String> modelTypeIds) {
        ImList<ModelItem> modelItems = this.modelItems;
        if (modelTypeIds != null) {
            ArrayList<ModelItem> matches = new ArrayList<ModelItem>(modelTypeIds.size());
            for (ModelItem modelItem : modelItems) {
                if (!modelTypeIds.contains(modelItem.modelTypeId)) continue;
                matches.add(modelItem);
            }
            return matches;
        }
        return modelItems;
    }

    private class CleanupJob
    extends Job {
        private final Object scheduleLock;

        public CleanupJob() {
            super("SourceUnit Cleanup");
            this.scheduleLock = new Object();
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(50);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void initialSchedule() {
            Object object = this.scheduleLock;
            synchronized (object) {
                this.schedule(180000L);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            Object object = this.scheduleLock;
            synchronized (object) {
                this.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            int count = SourceUnitManagerImpl.this.performCleanup();
            Object object = this.scheduleLock;
            synchronized (object) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                this.schedule(count > 0 ? 60000 : 180000);
                return Status.OK_STATUS;
            }
        }
    }

    private static class ContextItem {
        private final WorkingContext context;
        private final SourceUnitFactory factory;
        private final HashMap<String, SuItem> sus;
        private final ReferenceQueue<SourceUnit> susToClean;

        public ContextItem(WorkingContext context, SourceUnitFactory factory) {
            this.context = context;
            this.factory = factory;
            this.sus = new HashMap();
            this.susToClean = new ReferenceQueue();
        }

        public int hashCode() {
            return this.context.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof ContextItem) {
                return ((ContextItem)obj).context == this.context;
            }
            return false;
        }

        public synchronized @Nullable SourceUnit getOpenSu(Object from) {
            SourceUnit su;
            SuItem suItem;
            String id = this.factory.createId(from);
            if (id != null && (suItem = this.sus.get(id)) != null && (su = (SourceUnit)suItem.get()) != null && !suItem.isEnqueued()) {
                return su;
            }
            return null;
        }

        public synchronized void appendOpenSus(ArrayList<SourceUnit> list) {
            Collection<SuItem> suItems = this.sus.values();
            list.ensureCapacity(list.size() + suItems.size());
            for (SuItem suItem : suItems) {
                SourceUnit su = (SourceUnit)suItem.get();
                if (su == null || suItem.isEnqueued()) continue;
                list.add(su);
            }
        }
    }

    private static class ModelItem {
        private final String modelTypeId;
        private volatile ImList<ContextItem> contextItems = ImCollections.newList();

        public ModelItem(String modelTypeId) {
            this.modelTypeId = modelTypeId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Nullable ContextItem getContextItem(WorkingContext context, boolean create) {
            ImList<ContextItem> contextItems = this.contextItems;
            for (ContextItem contextItem : contextItems) {
                if (contextItem.context != context) continue;
                return contextItem;
            }
            if (create) {
                ModelItem modelItem = this;
                synchronized (modelItem) {
                    if (contextItems != this.contextItems) {
                        return this.getContextItem(context, true);
                    }
                    try {
                        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.statet.ltk.ModelTypes");
                        IConfigurationElement matchingElement = null;
                        IConfigurationElement[] iConfigurationElementArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IConfigurationElement element = iConfigurationElementArray[n2];
                            if (element.getName().equals("unitType") && element.isValid()) {
                                String typeIdOfElement = element.getAttribute(SourceUnitManagerImpl.CONFIG_MODELTYPE_ID_ATTRIBUTE_NAME);
                                String contextKeyOfElement = element.getAttribute(SourceUnitManagerImpl.CONFIG_CONTEXT_KEY_ATTRIBUTE_NAME);
                                if (this.modelTypeId.equals(typeIdOfElement)) {
                                    if (contextKeyOfElement == null || contextKeyOfElement.length() == 0) {
                                        matchingElement = element;
                                    } else if (contextKeyOfElement.equals(context.getKey())) {
                                        matchingElement = element;
                                        break;
                                    }
                                }
                            }
                            ++n2;
                        }
                        if (matchingElement != null) {
                            SourceUnitFactory factory = (SourceUnitFactory)matchingElement.createExecutableExtension("unitFactory");
                            ContextItem contextItem = new ContextItem(context, factory);
                            this.contextItems = ImCollections.addElement(contextItems, (Object)contextItem);
                            return contextItem;
                        }
                    }
                    catch (Exception e) {
                        LtkCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.ltk.core", 0, "Error loading working context contributions", (Throwable)e));
                    }
                }
            }
            return null;
        }

        public ImList<ContextItem> getOpenContextItems(@Nullable WorkingContext context) {
            ImList<ContextItem> contextItems = this.contextItems;
            if (context != null) {
                for (ContextItem contextItem : contextItems) {
                    if (contextItem.context != context) continue;
                    return ImCollections.newList((Object)contextItem);
                }
                return ImCollections.emptyList();
            }
            return contextItems;
        }

        public int hashCode() {
            return this.modelTypeId.hashCode();
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof ModelItem && this.modelTypeId.equals(((ModelItem)obj).modelTypeId);
        }
    }

    private static final class SuItem
    extends SoftReference<SourceUnit> {
        private final String key;

        public SuItem(String key, SourceUnit su, ReferenceQueue<SourceUnit> queue) {
            super(su, queue);
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void dispose() {
            SourceUnit su = (SourceUnit)this.get();
            if (su != null && su.isConnected()) {
                LtkCorePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ltk.core", -1, NLS.bind((String)"Source Unit ''{0}'' disposed but connected.", (Object)su.getId()), null));
            }
            this.clear();
        }
    }
}

