/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.rhelp.core.index;

import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.en.EnglishPossessiveFilter;
import org.apache.lucene.analysis.miscellaneous.KeywordRepeatFilter;
import org.apache.lucene.analysis.miscellaneous.RemoveDuplicatesTokenFilter;
import org.apache.lucene.analysis.snowball.SnowballFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.tartarus.snowball.SnowballProgram;
import org.tartarus.snowball.ext.EnglishStemmer;

final class DefaultAnalyzer
extends StopwordAnalyzerBase {
    public static final CharArraySet STOP_WORDS_SET = EnglishAnalyzer.ENGLISH_STOP_WORDS_SET;
    private final CharFilterFactory charFilterFactory;

    public DefaultAnalyzer() {
        this(null);
    }

    public DefaultAnalyzer(CharFilterFactory charFilterFactory) {
        super(STOP_WORDS_SET);
        this.charFilterFactory = charFilterFactory;
    }

    protected Reader initReader(String fieldName, Reader reader) {
        if (this.charFilterFactory != null) {
            reader = this.charFilterFactory.create(reader);
        }
        return super.initReader(fieldName, reader);
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        StandardTokenizer source;
        StandardTokenizer result = source = new StandardTokenizer();
        result = new EnglishPossessiveFilter((TokenStream)result);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopwords);
        result = new KeywordRepeatFilter((TokenStream)result);
        result = new SnowballFilter((TokenStream)result, (SnowballProgram)new EnglishStemmer());
        result = new RemoveDuplicatesTokenFilter((TokenStream)result);
        return new Analyzer.TokenStreamComponents((Tokenizer)source, (TokenStream)result);
    }
}

