/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.redocs.wikitext.r.ui.editors;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.statet.docmlet.base.ui.markuphelp.MarkupHelpContextProvider;
import org.eclipse.statet.docmlet.base.ui.processing.actions.RunDocProcessingOnSaveExtension;
import org.eclipse.statet.docmlet.base.ui.sourceediting.DocEditor;
import org.eclipse.statet.docmlet.wikitext.core.WikitextCore;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextModel;
import org.eclipse.statet.docmlet.wikitext.ui.WikitextUI;
import org.eclipse.statet.docmlet.wikitext.ui.editors.WikidocDefaultFoldingProvider;
import org.eclipse.statet.docmlet.wikitext.ui.editors.WikitextMarkOccurrencesLocator;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikitextEditingSettings;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.internal.redocs.wikitext.r.RedocsWikitextRPlugin;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.editors.WikidocRweaveEditorTemplatesPage;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.editors.WikidocRweaveOutlinePage;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.sourceediting.AbstractMarkOccurrencesProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ForwardSourceDocumentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceDocumentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1OutlinePage;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfigurator;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.folding.FoldingProvider;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.core.source.RDocumentConstants;
import org.eclipse.statet.r.ui.editors.IRSourceEditor;
import org.eclipse.statet.r.ui.editors.RCorrectIndentHandler;
import org.eclipse.statet.r.ui.editors.RDefaultFoldingProvider;
import org.eclipse.statet.r.ui.editors.RMarkOccurrencesLocator;
import org.eclipse.statet.r.ui.sourceediting.InsertAssignmentHandler;
import org.eclipse.statet.redocs.r.core.source.DocContentSectionsRweaveExtension;
import org.eclipse.statet.redocs.r.ui.sourceediting.actions.RweaveToggleCommentHandler;
import org.eclipse.statet.redocs.wikitext.r.core.model.WikidocRweaveSourceUnit;
import org.eclipse.statet.redocs.wikitext.r.core.source.WikidocRweaveDocumentContentInfo;
import org.eclipse.statet.redocs.wikitext.r.core.source.WikidocRweaveDocumentSetupParticipant;
import org.eclipse.statet.redocs.wikitext.r.ui.editors.WikidocRweaveEditor;
import org.eclipse.statet.redocs.wikitext.r.ui.sourceediting.WikidocRweaveSourceViewerConfiguration;
import org.eclipse.statet.redocs.wikitext.r.ui.sourceediting.WikidocRweaveSourceViewerConfigurator;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.templates.ITemplatesPage;

public abstract class WikidocRweaveDocEditor
extends SourceEditor1
implements WikidocRweaveEditor,
DocEditor,
MarkupHelpContextProvider {
    private static final ImList<String> KEY_CONTEXTS = ImCollections.newIdentityList((Object[])new String[]{"org.eclipse.statet.docmlet.contexts.WikitextEditor", "org.eclipse.statet.docmlet.contexts.DocEditor", "org.eclipse.statet.redocs.contexts.RweaveEditorScope"});
    private static final ImList<String> CONTEXT_IDS = ImCollections.concatList((Collection)ACTION_SET_CONTEXT_IDS, KEY_CONTEXTS);
    private final WikidocRweaveDocumentSetupParticipant documentSetup;
    private WikidocRweaveSourceViewerConfigurator combinedConfig;
    private final RunDocProcessingOnSaveExtension autoDocProcessing;

    public WikidocRweaveDocEditor(IContentType contentType, WikidocRweaveDocumentSetupParticipant documentSetup) {
        super(contentType);
        if (documentSetup == null) {
            throw new NullPointerException("documentSetup");
        }
        this.documentSetup = documentSetup;
        this.autoDocProcessing = new RunDocProcessingOnSaveExtension((SourceEditor1)this);
        this.initializeEditor();
    }

    protected void initializeEditor() {
        if (this.documentSetup == null) {
            return;
        }
        super.initializeEditor();
        this.setEditorContextMenuId("org.eclipse.statet.redocs.menus.WikidocRweaveEditorContextMenu");
        this.setRulerContextMenuId("org.eclipse.statet.redocs.menus.WikidocRweaveEditorRulerMenu");
    }

    protected SourceEditorViewerConfigurator createConfiguration() {
        this.setDocumentProvider((IDocumentProvider)new ForwardSourceDocumentProvider((SourceDocumentProvider)RedocsWikitextRPlugin.getInstance().getDocRDocumentProvider(), (IDocumentSetupParticipant)this.documentSetup));
        this.enableStructuralFeatures(WikitextModel.getWikidocModelManager(), (Preference)WikitextEditingSettings.FOLDING_ENABLED_PREF, (Preference)WikitextEditingSettings.MARKOCCURRENCES_ENABLED_PREF);
        this.combinedConfig = new WikidocRweaveSourceViewerConfigurator(this.documentSetup, WikitextCore.WORKBENCH_ACCESS, RCore.WORKBENCH_ACCESS, new WikidocRweaveSourceViewerConfiguration(0, this, null, null, null));
        return this.combinedConfig;
    }

    protected int getSourceViewerFlags() {
        return 16;
    }

    protected Collection<String> getContextIds() {
        return CONTEXT_IDS;
    }

    protected ISourceEditorAddon createCodeFoldingProvider() {
        return new FoldingEditorAddon((FoldingProvider)new WikidocDefaultFoldingProvider(Collections.singletonMap("R", new RDefaultFoldingProvider())));
    }

    protected ISourceEditorAddon createMarkOccurrencesProvider() {
        return new ThisMarkOccurrencesProvider(this);
    }

    public RCoreAccess getRCoreAccess() {
        return this.combinedConfig.getRCoreAccess();
    }

    public DocContentSectionsRweaveExtension getDocumentContentInfo() {
        return (DocContentSectionsRweaveExtension)super.getDocumentContentInfo();
    }

    @Override
    public WikidocRweaveSourceUnit getSourceUnit() {
        return (WikidocRweaveSourceUnit)super.getSourceUnit();
    }

    protected void setupConfiguration(IEditorInput newInput) {
        super.setupConfiguration(newInput);
        WikidocRweaveSourceUnit su = this.getSourceUnit();
        this.combinedConfig.setSource(su != null ? su.getWikitextCoreAccess() : WikitextCore.WORKBENCH_ACCESS, su != null ? su.getRCoreAccess() : RCore.WORKBENCH_ACCESS);
        this.autoDocProcessing.setAutoRunEnabled(false);
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if ("tabWidth".equals(event.getProperty()) || "spacesForTabs".equals(event.getProperty())) {
            return;
        }
        super.handlePreferenceStoreChanged(event);
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        return false;
    }

    public void updateSettings(boolean indentChanged) {
        if (indentChanged) {
            this.updateIndentPrefixes();
        }
    }

    protected void collectContextMenuPreferencePages(List<String> pageIds) {
        super.collectContextMenuPreferencePages(pageIds);
        pageIds.add("org.eclipse.statet.redocs.preferencePages.WikitextREditor");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.WikitextEditor");
        pageIds.add("org.eclipse.mylyn.internal.wikitext.ui.editor.preferences.WikiTextTemplatePreferencePage");
        pageIds.add("org.eclipse.statet.docmlet.preferencePages.WikitextCodeStyle");
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorOptions");
        pageIds.add("org.eclipse.statet.r.preferencePages.RTextStyles");
        pageIds.add("org.eclipse.statet.r.preferencePages.REditorTemplates");
        pageIds.add("org.eclipse.statet.r.preferencePages.RCodeStyle");
    }

    protected void createActions() {
        super.createActions();
        IHandlerService handlerService = (IHandlerService)this.getServiceLocator().getService(IHandlerService.class);
        InsertAssignmentHandler handler = new InsertAssignmentHandler((ISourceEditor)this);
        handlerService.activateHandler("org.eclipse.statet.ltk.commands.InsertAssignment", (IHandler)handler);
        this.markAsStateDependentHandler((IHandler2)handler, true);
    }

    protected IHandler2 createToggleCommentHandler() {
        RweaveToggleCommentHandler handler = new RweaveToggleCommentHandler(this){

            protected Pattern getPrefixPattern(String contentType, String prefix) {
                if (prefix.equals("<!--")) {
                    return HTML_SPACE_PREFIX_PATTERN;
                }
                return super.getPrefixPattern(contentType, prefix);
            }

            protected Pattern getPostfixPattern(String contentType, String prefix) {
                if (prefix.equals("<!--")) {
                    return HTML_SPACE_POSTFIX_PATTERN;
                }
                return super.getPostfixPattern(contentType, prefix);
            }

            protected void doPrefixPrimary(AbstractDocument document, IRegion block) throws BadLocationException, BadPartitioningException {
                this.doPrefix(document, block, "<!-- ", " -->");
            }
        };
        this.markAsStateDependentHandler((IHandler2)handler, true);
        return handler;
    }

    protected IHandler2 createCorrectIndentHandler() {
        ThisCorrectIndentHandler handler = new ThisCorrectIndentHandler((IRSourceEditor)this);
        this.markAsStateDependentHandler((IHandler2)handler, true);
        return handler;
    }

    protected void editorContextMenuAboutToShow(IMenuManager m) {
        super.editorContextMenuAboutToShow(m);
        WikidocRweaveSourceUnit su = this.getSourceUnit();
        m.insertBefore("additions", (IContributionItem)new Separator("stat.submit"));
        IContributionItem additions = m.find("additions");
        if (additions != null) {
            additions.setVisible(false);
        }
        m.remove("ShiftRight");
        m.remove("ShiftLeft");
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.SubmitSelectionToR", 8)));
        m.appendToGroup("stat.submit", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.r.commands.SubmitUptoSelectionToR", 8)));
        m.appendToGroup("settings", (IContributionItem)new CommandContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), null, "org.eclipse.statet.docmlet.commands.ConfigureMarkup", null, null, null, null, "Configure Markup...", "M", null, 8, null, false)));
    }

    protected void editorSaved() {
        super.editorSaved();
        this.autoDocProcessing.onEditorSaved();
    }

    protected SourceEditor1OutlinePage createOutlinePage() {
        return new WikidocRweaveOutlinePage(this);
    }

    protected ITemplatesPage createTemplatesPage() {
        return new WikidocRweaveEditorTemplatesPage(this);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer", "org.eclipse.ui.views.ContentOutline", "org.eclipse.statet.r.views.RHelp"};
    }

    public @Nullable String getHelpContentId() {
        return WikitextUI.getMarkupHelpContentIdFor((WikitextMarkupLanguage)this.documentSetup.getMarkupLanguage());
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == MarkupHelpContextProvider.class) {
            return (T)this;
        }
        if (adapterType == RunDocProcessingOnSaveExtension.class) {
            return (T)this.autoDocProcessing;
        }
        if (adapterType == REnv.class) {
            return (T)this.getRCoreAccess().getREnv();
        }
        return (T)super.getAdapter(adapterType);
    }

    private static class ThisCorrectIndentHandler
    extends RCorrectIndentHandler {
        public ThisCorrectIndentHandler(IRSourceEditor editor) {
            super((ISourceEditor)editor);
        }

        protected List<? extends TextRegion> getCodeRanges(AbstractDocument document, ITextSelection selection) throws BadLocationException {
            return WikidocRweaveDocumentContentInfo.INSTANCE.getRChunkCodeRegions((IDocument)document, selection.getOffset(), selection.getLength());
        }
    }

    private static class ThisMarkOccurrencesProvider
    extends AbstractMarkOccurrencesProvider {
        private final WikitextMarkOccurrencesLocator docLocator = new WikitextMarkOccurrencesLocator();
        private final RMarkOccurrencesLocator rLocator = new RMarkOccurrencesLocator();

        public ThisMarkOccurrencesProvider(SourceEditor1 editor) {
            super(editor, RDocumentConstants.R_DEFAULT_CONTENT_CONSTRAINT);
        }

        protected void doUpdate(AbstractMarkOccurrencesProvider.RunData run, SourceUnitModelInfo info, AstSelection astSelection, ITextSelection orgSelection) throws BadLocationException, BadPartitioningException, UnsupportedOperationException {
            if (astSelection.getCovering() instanceof WikitextAstNode) {
                this.docLocator.run(run, info, astSelection, orgSelection);
            } else if (astSelection.getCovering() instanceof RAstNode) {
                this.rLocator.run(run, info, astSelection, orgSelection);
            }
        }
    }
}

