/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r.ui.sourceediting;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.source.MarkupLanguageDocumentSetupParticipant;
import org.eclipse.statet.internal.redocs.wikitext.r.RedocsWikitextRPlugin;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateCompletionComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.redocs.r.ui.RedocsRUIResources;
import org.eclipse.statet.redocs.wikitext.r.core.source.RweaveMarkupLanguage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.templates.ContextTypeRegistry;

@NonNullByDefault
public class RChunkTemplateCompletionComputer
extends TemplateCompletionComputer {
    private @Nullable RweaveMarkupLanguage markupLanguage;

    public RChunkTemplateCompletionComputer() {
        super(RedocsWikitextRPlugin.getInstance().getCodegenTemplateStore(), (ContextTypeRegistry)RedocsWikitextRPlugin.getInstance().getCodegenTemplateContextTypeRegistry());
    }

    public void onSessionStarted(ISourceEditor editor, ContentAssist assist) {
        WikitextMarkupLanguage markupLanguage = MarkupLanguageDocumentSetupParticipant.getMarkupLanguage((IDocument)editor.getViewer().getDocument(), (String)editor.getDocumentContentInfo().getPartitioning());
        if (markupLanguage instanceof RweaveMarkupLanguage) {
            this.markupLanguage = (RweaveMarkupLanguage)markupLanguage;
        }
    }

    public void onSessionEnded() {
        this.markupLanguage = null;
    }

    public void computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        if (mode == 1) {
            mode = 2;
        }
        this.onSessionStarted(context.getEditor(), null);
        try {
            if (this.markupLanguage == null) {
                return;
            }
            super.computeCompletionProposals(context, mode, proposals, monitor);
        }
        finally {
            this.onSessionEnded();
        }
    }

    protected boolean include(Template template, TemplateProposal.TemplateProposalParameters<?> parameters) {
        String templatePattern = template.getPattern();
        int varIdx = templatePattern.indexOf("${");
        if ((varIdx < 0 || varIdx >= parameters.namePattern.getPattern().length()) && templatePattern.startsWith(parameters.namePattern.getPattern())) {
            parameters.matchRule = 0x1000000;
            return true;
        }
        return false;
    }

    protected @Nullable String extractPrefix(AssistInvocationContext context) {
        IDocument document = context.getSourceViewer().getDocument();
        int offset = context.getOffset();
        try {
            int lineOffset = document.getLineOffset(document.getLineOfOffset(offset));
            String prefix = document.get(lineOffset, offset - lineOffset);
            List<String> indentPrefixes = this.markupLanguage.getIndentPrefixes();
            block2: while (!prefix.isEmpty()) {
                for (String indentPrefix : indentPrefixes) {
                    if (!prefix.startsWith(indentPrefix)) continue;
                    prefix = prefix.substring(indentPrefix.length());
                    continue block2;
                }
                return prefix;
            }
            return "";
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    protected @Nullable TemplateContextType getContextType(AssistInvocationContext context, TextRegion region) {
        RweaveMarkupLanguage markupLanguage = this.markupLanguage;
        return markupLanguage != null ? this.getTypeRegistry().getContextType(String.valueOf(markupLanguage.getName()) + "weave_Weave:DocDefault") : null;
    }

    protected TemplateProposal createProposal(TemplateProposal.TemplateProposalParameters<?> parameters) {
        if (parameters.matchRule == 0x1000000) {
            parameters.baseRelevance = 90;
        }
        return super.createProposal(parameters);
    }

    protected Image getImage(Template template) {
        return RedocsRUIResources.INSTANCE.getImage("org.eclipse.statet.redocs.r/image/obj/rchunk");
    }
}

