/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.tex.r.ui.sourceediting;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.model.core.element.EmbeddingForeignElement;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.ui.sourceediting.OutlineContentProvider;

@NonNullByDefault
public class DocROutlineContentProvider
extends OutlineContentProvider {
    public DocROutlineContentProvider(OutlineContentProvider.OutlineContent content) {
        super(content);
    }

    private boolean skipToForeignElement(@Nullable SourceStructElement<?, ?> element) {
        return element != null && element.getModelTypeId() == "Ltx" && element.getElementType() == 2048;
    }

    public @Nullable SourceStructElement getParent(SourceStructElement<?, ?> element) {
        SourceStructElement parent = super.getParent(element);
        if (parent != null && this.skipToForeignElement(parent.getSourceParent())) {
            return parent.getSourceParent();
        }
        return parent;
    }

    public boolean hasChildren(@Nullable SourceStructElement<?, ?> element) {
        if (this.skipToForeignElement(element)) {
            SourceStructElement foreignElement = ((EmbeddingForeignElement)element).getForeignElement();
            return super.hasChildren(foreignElement);
        }
        return super.hasChildren(element);
    }

    public SourceStructElement[] getChildren(@Nullable SourceStructElement<?, ?> element) {
        if (this.skipToForeignElement(element)) {
            SourceStructElement foreignElement = ((EmbeddingForeignElement)element).getForeignElement();
            return super.getChildren(foreignElement);
        }
        return super.getChildren(element);
    }
}

