/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.r.ui.dataeditor.RDataTableContentDescription;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.internal.r.ui.datafilter.IFilterListener;
import org.eclipse.statet.internal.r.ui.datafilter.IntervalVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.LevelVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.Messages;
import org.eclipse.statet.internal.r.ui.datafilter.TextVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RFactorStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.ts.core.RToolService;

public class FilterSet {
    private static final int POST_DELAY = 400;
    private static final int STD_DELAY = 1;
    private static final int NO_DELAY = 2;
    private RDataTableContentDescription input;
    private boolean inputUpdate;
    private final Object updateLock = new Object();
    private boolean updateScheduled;
    private final ToolRunnable updateRunnable = new SystemRunnable(){

        public String getTypeId() {
            return "r/datafilter/load";
        }

        public String getLabel() {
            return NLS.bind((String)Messages.UpdateJob_label, (Object)FilterSet.this.input.getLabel());
        }

        public boolean canRunIn(Tool tool) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean changed(int event, Tool tool) {
            switch (event) {
                case 289: {
                    return false;
                }
                case 288: 
                case 290: {
                    Object object = FilterSet.this.updateLock;
                    synchronized (object) {
                        FilterSet.this.updateScheduled = false;
                        FilterSet.this.updateLock.notifyAll();
                        break;
                    }
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            FilterSet.this.runUpdate((RToolService)service, m);
        }
    };
    private boolean updateAll;
    private final List<VariableFilter> filters = new ArrayList<VariableFilter>();
    private final List<String> filterNames = new ArrayList<String>();
    private final CopyOnWriteIdentityListSet<IFilterListener> listeners = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<IFilterListener> postListeners = new CopyOnWriteIdentityListSet();
    private volatile int listenerScheduled;
    private final Runnable listenerRunnable = new Runnable(){

        @Override
        public void run() {
            int schedule = FilterSet.this.listenerScheduled;
            FilterSet.this.listenerScheduled = 0;
            for (IFilterListener listener : FilterSet.this.listeners.toList()) {
                listener.filterChanged();
            }
            if (schedule != 2) {
                FilterSet.this.postListenerTime = System.nanoTime() + 400L;
                if (FilterSet.this.postListenerScheduled) {
                    return;
                }
                FilterSet.this.postListenerScheduled = true;
                FilterSet.this.realm.timerExec(400, FilterSet.this.postListenerRunnable);
            } else {
                FilterSet.this.postListenerTime = System.nanoTime();
                FilterSet.this.postListenerScheduled = true;
                FilterSet.this.postListenerRunnable.run();
            }
        }
    };
    private boolean postListenerScheduled;
    private long postListenerTime;
    private final Runnable postListenerRunnable = new Runnable(){

        @Override
        public void run() {
            if (FilterSet.this.listenerScheduled > 0) {
                FilterSet.this.postListenerScheduled = false;
                return;
            }
            long time = FilterSet.this.postListenerTime - System.nanoTime();
            if (time > 20L) {
                FilterSet.this.realm.timerExec((int)time, (Runnable)this);
                return;
            }
            FilterSet.this.postListenerScheduled = false;
            for (IFilterListener listener : FilterSet.this.postListeners.toList()) {
                listener.filterChanged();
            }
        }
    };
    private final Realm realm;
    private boolean enabled;
    private String filterRExpression;

    public FilterSet(Realm realm) {
        this.realm = realm;
        this.enabled = true;
    }

    public Realm getRealm() {
        return this.realm;
    }

    protected void runInRealm(Runnable runnable) {
        if (this.realm.isCurrent()) {
            runnable.run();
        } else {
            this.realm.asyncExec(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateInput(RDataTableContentDescription input) {
        Object object = this.updateLock;
        synchronized (object) {
            this.input = input;
            this.inputUpdate = true;
        }
        object = this;
        synchronized (object) {
            int idx = 0;
            if (input != null) {
                List<RDataTableColumn> columns = input.getDataColumns();
                while (idx < columns.size()) {
                    VariableFilter filter;
                    RDataTableColumn column = columns.get(idx);
                    if (column.getRExpression() != null && column.getName() != null && (filter = this.createFilter(this.getDefaultFilter(column), column)) != null) {
                        int oldIdx = this.filterNames.indexOf(column.getName());
                        if (oldIdx >= 0) {
                            VariableFilter oldFilter = this.filters.get(oldIdx);
                            filter.load(oldFilter);
                            if (idx != oldIdx) {
                                this.filterNames.remove(oldIdx);
                                this.filters.remove(oldIdx);
                                this.filterNames.add(idx, column.getName());
                                this.filters.add(idx, filter);
                            } else {
                                this.filters.set(idx, filter);
                            }
                            this.filterReplaced(idx, oldFilter, filter);
                        } else {
                            this.filterNames.add(idx, column.getName());
                            this.filters.add(idx, filter);
                            this.filterAdded(idx, filter);
                        }
                    }
                    ++idx;
                }
            }
            while (this.filters.size() > idx) {
                this.filterNames.remove(idx);
                VariableFilter oldFilter = this.filters.remove(idx);
                this.filterRemoved(oldFilter);
            }
        }
        object = this.updateLock;
        synchronized (object) {
            this.inputUpdate = false;
            this.scheduleUpdate(true);
        }
    }

    protected void filterRemoved(VariableFilter oldFilter) {
    }

    protected void filterReplaced(int idx, VariableFilter oldFilter, VariableFilter newFilter) {
    }

    protected void filterAdded(int idx, VariableFilter newFilter) {
    }

    public FilterType getDefaultFilter(RDataTableColumn column) {
        switch (column.getVarType()) {
            case 1: 
            case 6: 
            case 10: {
                return FilterType.LEVEL;
            }
            case 2: 
            case 3: 
            case 17: 
            case 19: {
                return FilterType.INTERVAL;
            }
            case 5: {
                return FilterType.TEXT;
            }
        }
        return null;
    }

    public ImList<FilterType> getAvailableFilters(RDataTableColumn column) {
        switch (column.getVarType()) {
            case 1: 
            case 6: {
                return ImCollections.newList((Object)FilterType.LEVEL);
            }
            case 10: {
                if (((RFactorStore)column.getDataStore()).isOrdered()) {
                    return ImCollections.newList((Object[])new FilterType[]{FilterType.LEVEL, FilterType.INTERVAL});
                }
                return ImCollections.newList((Object)FilterType.LEVEL);
            }
            case 2: 
            case 3: 
            case 17: 
            case 19: {
                return ImCollections.newList((Object[])new FilterType[]{FilterType.INTERVAL, FilterType.LEVEL});
            }
            case 5: {
                return ImCollections.newList((Object[])new FilterType[]{FilterType.TEXT, FilterType.LEVEL});
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableFilter replace(VariableFilter currentFilter, FilterType filterType) {
        VariableFilter filter;
        Object object = this.updateLock;
        synchronized (object) {
            this.inputUpdate = true;
        }
        Object object2 = this;
        synchronized (object2) {
            int idx = this.filters.indexOf(currentFilter);
            if (idx < 0) {
                return currentFilter;
            }
            filter = this.createFilter(filterType, currentFilter.getColumn());
            if (filter == null) {
                return currentFilter;
            }
            filter.load(currentFilter);
            this.filters.set(idx, filter);
            this.filterReplaced(idx, currentFilter, filter);
        }
        object2 = this.updateLock;
        synchronized (object2) {
            this.inputUpdate = false;
            filter.scheduleUpdate();
        }
        return filter;
    }

    protected VariableFilter createFilter(FilterType filterType, RDataTableColumn column) {
        if (filterType == null) {
            return null;
        }
        switch (filterType.getId()) {
            case 0: {
                return new LevelVariableFilter(this, column);
            }
            case 1: {
                return new IntervalVariableFilter(this, column);
            }
            case 2: {
                return new TextVariableFilter(this, column);
            }
        }
        throw new UnsupportedOperationException(filterType.toString());
    }

    public synchronized ImList<VariableFilter> getFilters() {
        return ImCollections.toList(this.filters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleUpdate(boolean all) {
        Object object = this.updateLock;
        synchronized (object) {
            if (all) {
                this.updateAll = true;
            }
            if (this.updateScheduled || this.inputUpdate) {
                return;
            }
            if (this.input != null) {
                this.input.getRHandle().getQueue().add(this.updateRunnable);
                this.updateScheduled = true;
            }
        }
    }

    protected Tool getTool() {
        RDataTableContentDescription input = this.input;
        return input != null ? input.getRHandle() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUpdate(RToolService r, ProgressMonitor m) {
        VariableFilter[] filters;
        boolean all;
        Object object = this.updateLock;
        synchronized (object) {
            this.updateScheduled = false;
            if (this.inputUpdate || this.input == null || this.input.getRHandle() != r.getTool()) {
                return;
            }
            all = this.updateAll;
            this.updateAll = false;
        }
        FilterSet filterSet = this;
        synchronized (filterSet) {
            filters = this.filters.toArray(new VariableFilter[this.filters.size()]);
        }
        int i = 0;
        while (i < filters.length) {
            VariableFilter filter = filters[i];
            if (all || filter.updateScheduled) {
                filter.updateScheduled = false;
                Throwable error = null;
                try {
                    filter.update(r, m);
                }
                catch (StatusException e) {
                    error = e;
                }
                catch (UnexpectedRDataException e) {
                    error = e;
                }
                if (error != null) {
                    error.printStackTrace();
                    filters[i].setError(error.getMessage());
                }
            }
            ++i;
        }
        this.updateFilter(true);
    }

    public void addListener(IFilterListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IFilterListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void addPostListener(IFilterListener listener) {
        this.postListeners.add((Object)listener);
    }

    public void removePostListener(IFilterListener listener) {
        this.postListeners.remove((Object)listener);
    }

    public String getFilterRExpression() {
        return this.filterRExpression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFilterRExpression(String varExpression, int nameFlags) {
        VariableFilter[] filters;
        FilterSet filterSet = this;
        synchronized (filterSet) {
            block8: {
                if (!this.inputUpdate && this.input != null) break block8;
                return null;
            }
            filters = this.filters.toArray(new VariableFilter[this.filters.size()]);
        }
        if (varExpression == null) {
            varExpression = this.input.getElementName().getDisplayName(nameFlags);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < filters.length) {
            VariableFilter filter = filters[i];
            String rExpression = filter.getFilterRExpression(varExpression, nameFlags);
            if (rExpression != null && !rExpression.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append(" & ");
                }
                sb.append(rExpression);
            }
            ++i;
        }
        return sb.toString();
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.notifyListeners(2);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFilter(boolean delay) {
        String filterRExpression;
        VariableFilter[] filters;
        FilterSet filterSet = this;
        synchronized (filterSet) {
            if (this.inputUpdate || this.input == null) {
                return;
            }
            filters = this.filters.toArray(new VariableFilter[this.filters.size()]);
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < filters.length) {
            VariableFilter filter = filters[i];
            String rExpression = filter.getFilterRExpression();
            if (rExpression != null && !rExpression.isEmpty()) {
                if (sb.length() > 0) {
                    sb.append(" & ");
                }
                sb.append(rExpression);
            }
            ++i;
        }
        if (sb.length() == 0) {
            filterRExpression = null;
            if (this.filterRExpression == null) {
                return;
            }
        } else {
            filterRExpression = sb.toString();
            if (filterRExpression.equals(this.filterRExpression)) {
                return;
            }
        }
        this.filterRExpression = filterRExpression;
        this.notifyListeners(delay ? 1 : 2);
    }

    private void notifyListeners(int mode) {
        int schedule = this.listenerScheduled;
        if (schedule >= mode) {
            return;
        }
        this.listenerScheduled = mode;
        this.runInRealm(this.listenerRunnable);
    }
}

