/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.assist;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.util.InformationDispatchHandler;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.debug.ui.assist.Messages;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.RLabelProvider;
import org.eclipse.statet.r.ui.dataeditor.RDataEditor;
import org.eclipse.statet.r.ui.dataeditor.RLiveDataEditorInput;
import org.eclipse.statet.r.ui.rtool.RElementInfoHoverCreator;
import org.eclipse.statet.r.ui.rtool.RElementInfoTask;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.IServiceLocator;

public class RElementInfoControl
extends AbstractInformationControl
implements IInformationControlExtension2,
IPropertyChangeListener {
    private final int mode;
    private RLabelProvider labelProvider;
    private Composite contentComposite;
    private Label titleImage;
    private StyledText titleText;
    private StyledText infoText;
    private boolean layoutWorkaround;
    private boolean layoutHint;
    private RElementInfoTask.RElementInfoData input;
    private boolean inputChanged;

    public RElementInfoControl(Shell shell, int mode) {
        super(shell, "");
        assert ((mode & 0x10) == 0);
        this.mode = mode;
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.create();
    }

    public RElementInfoControl(Shell shell, int mode, boolean dummy) {
        super(shell, new ToolBarManager(0x800000));
        assert ((mode & 0x10) != 0);
        this.mode = mode;
        this.create();
    }

    public void setInput(Object input) {
        this.inputChanged = true;
        this.input = input instanceof RElementInfoTask.RElementInfoData ? (RElementInfoTask.RElementInfoData)input : null;
    }

    public RElementInfoTask.RElementInfoData getInput() {
        return this.input;
    }

    public boolean hasContents() {
        return this.input != null;
    }

    protected void createContent(Composite parent) {
        this.contentComposite = new Composite(parent, 0){

            public Point computeSize(int width, int height, boolean changed) {
                return super.computeSize(width, height, changed || width != this.getSize().x);
            }
        };
        this.contentComposite.setBackgroundMode(2);
        GridLayout gridLayout = LayoutUtils.newCompositeGrid((int)2);
        gridLayout.horizontalSpacing = (int)((double)gridLayout.horizontalSpacing / 1.5);
        this.contentComposite.setLayout((Layout)gridLayout);
        int vIndent = Math.max(1, LayoutUtils.defaultVSpacing() / 4);
        int hIndent = Math.max(3, LayoutUtils.defaultHSpacing() / 2);
        this.titleImage = new Label(this.contentComposite, 0);
        Image image = SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy");
        this.titleImage.setImage(image);
        GridData textGd = new GridData(4, 128, false, false);
        this.titleText = new StyledText(this.contentComposite, 74){

            public Point computeSize(int width, int height, boolean changed) {
                if (!RElementInfoControl.this.layoutHint && width <= 0 && ((RElementInfoControl)RElementInfoControl.this).contentComposite.getSize().x > 0) {
                    width = ((RElementInfoControl)RElementInfoControl.this).contentComposite.getSize().x - LayoutUtils.defaultHMargin() - ((RElementInfoControl)RElementInfoControl.this).titleImage.getSize().x - LayoutUtils.defaultHSpacing() - 10;
                }
                Point size = super.computeSize(width, -1, true);
                return size;
            }
        };
        this.titleText.setFont(JFaceResources.getDialogFont());
        GC gc = new GC((Drawable)this.titleText);
        FontMetrics fontMetrics = gc.getFontMetrics();
        GridData imageGd = new GridData(4, 128, false, false);
        imageGd.horizontalIndent = hIndent;
        int textHeight = fontMetrics.getAscent() + fontMetrics.getLeading();
        int imageHeight = image.getBounds().height;
        int shift = Math.max(3, (int)((double)fontMetrics.getDescent() / 1.5));
        if (textHeight + shift < imageHeight) {
            imageGd.verticalIndent = vIndent + shift;
            textGd.verticalIndent = vIndent + (imageHeight - textHeight);
        } else {
            imageGd.verticalIndent = vIndent + (textHeight - imageHeight) + shift;
            textGd.verticalIndent = vIndent;
        }
        this.titleImage.setLayoutData((Object)imageGd);
        this.titleText.setLayoutData((Object)textGd);
        this.layoutWorkaround = true;
        gc.dispose();
        this.infoText = new StyledText(this.contentComposite, (this.mode & 0x10) != 0 ? 778 : 10);
        this.infoText.setIndent(hIndent);
        this.infoText.setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        GridData gd = new GridData(4, 4, true, true, 2, 1);
        this.infoText.setLayoutData((Object)gd);
        this.setBackgroundColor(this.getShell().getDisplay().getSystemColor(29));
        this.setForegroundColor(this.getShell().getDisplay().getSystemColor(28));
        if ((this.mode & 0x10) != 0) {
            ToolBarManager toolBarManager = this.getToolBarManager();
            this.contributeToActionBars((IServiceLocator)PlatformUI.getWorkbench(), toolBarManager, null);
        }
        this.updateInput();
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, ToolBarManager toolBarManager, HandlerCollection handlers) {
        toolBarManager.add((IContributionItem)new OpenInEditorItem());
    }

    public void setBackgroundColor(Color background) {
        super.setBackgroundColor(background);
        this.contentComposite.setBackground(background);
    }

    public void setForegroundColor(Color foreground) {
        super.setForegroundColor(foreground);
        this.contentComposite.setForeground(foreground);
        this.titleText.setForeground(foreground);
        this.infoText.setForeground(foreground);
    }

    public Rectangle computeTrim() {
        Rectangle trim = super.computeTrim();
        Rectangle textTrim = this.infoText.computeTrim(0, 0, 0, 0);
        trim.x += textTrim.x;
        trim.y += textTrim.y;
        trim.width += textTrim.width;
        trim.height += textTrim.height;
        return trim;
    }

    public Point computeSizeHint() {
        this.updateInput();
        Point sizeConstraints = this.getSizeConstraints();
        Rectangle trim = this.computeTrim();
        int widthHint = this.infoText.computeSize((int)-1, (int)-1, (boolean)true).x + LayoutUtils.defaultHSpacing();
        int widthMax2 = LayoutUtils.hintWidth((StyledText)this.infoText, (String)"org.eclipse.debug.ui.DetailPaneFont", (int)80);
        int widthMax = (sizeConstraints != null && sizeConstraints.x != -1 ? sizeConstraints.x : widthMax2) - trim.width;
        this.layoutHint = true;
        int titleHint = LayoutUtils.defaultHMargin() + this.titleImage.getSize().x + LayoutUtils.defaultHSpacing() + this.titleText.computeSize((int)-1, (int)-1).x;
        this.layoutHint = false;
        if (titleHint > widthHint && widthMax2 > widthHint) {
            widthHint = Math.min(widthMax2, titleHint);
        }
        if (widthMax < widthHint) {
            widthHint = widthMax;
        }
        if (widthHint < titleHint && widthHint + this.infoText.computeTrim((int)0, (int)0, (int)0, (int)0).width >= titleHint) {
            widthHint = titleHint;
        }
        int heightMax = (sizeConstraints != null && sizeConstraints.y != -1 ? sizeConstraints.y : this.infoText.getLineHeight() * 12) - trim.height;
        Point size = this.contentComposite.computeSize(widthHint, -1, true);
        size.y += LayoutUtils.defaultVSpacing();
        size.x = Math.max(Math.min(size.x, widthMax), 200) + trim.width;
        size.y = Math.max(Math.min(size.y, heightMax), 100) + trim.height;
        return size;
    }

    public Point computeSizeConstraints(int widthInChars, int heightInChars) {
        int titleWidth = LayoutUtils.hintWidth((StyledText)this.titleText, (String)"org.eclipse.jface.dialogfont", (int)widthInChars);
        int titleHeight = this.titleText.getLineHeight();
        int infoWidth = LayoutUtils.hintWidth((StyledText)this.infoText, (String)"org.eclipse.debug.ui.DetailPaneFont", (int)widthInChars);
        int infoHeight = this.infoText.getLineHeight() * heightInChars;
        return new Point(Math.max(titleWidth, infoWidth), titleHeight + LayoutUtils.defaultVSpacing() + infoHeight);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Shell shell;
            this.updateInput();
            if (this.layoutWorkaround) {
                this.contentComposite.layout(true, true);
                this.layoutWorkaround = false;
            }
            if ("win32".equals(SWT.getPlatform()) && (shell = this.getShell()) != null) {
                shell.moveAbove(null);
            }
        }
        super.setVisible(visible);
    }

    public void setFocus() {
        this.infoText.setFocus();
    }

    private void updateInput() {
        if (this.infoText == null || !this.inputChanged) {
            return;
        }
        if (this.labelProvider == null) {
            this.labelProvider = new RLabelProvider(7);
        }
        if (this.input != null) {
            Image image = this.labelProvider.getImage((LtkModelElement)this.input.getElement());
            this.titleImage.setImage(image != null ? image : SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy"));
            StyledString styleString = this.labelProvider.getStyledText((RElement)this.input.getElement(), this.input.getElementName(), this.input.getElementAttr());
            if (this.input.isElementOfActiveBinding()) {
                styleString.append(" (active binding)", StyledString.QUALIFIER_STYLER);
            }
            this.titleText.setText(styleString.getString());
            this.titleText.setStyleRanges(styleString.getStyleRanges());
            if (this.input.hasDetail()) {
                this.infoText.setText(String.valueOf(this.input.getDetailTitle()) + '\n' + (this.input.getDetailInfo() != null ? this.input.getDetailInfo() : ""));
                StyleRange title = new StyleRange(0, this.input.getDetailTitle().length(), null, null);
                title.underline = true;
                this.infoText.setStyleRange(title);
            } else {
                this.infoText.setText("");
            }
        } else {
            this.titleImage.setImage(SharedUIResources.getImages().get("org.eclipse.statet.ecommons.uimisc/image/obj/dummy"));
            this.titleText.setText("");
            this.infoText.setText("");
        }
        if ((this.mode & 0x10) != 0) {
            this.getToolBarManager().update(true);
        } else {
            this.setStatusText(this.input.getControl() != null && this.input.getControl().isFocusControl() ? InformationDispatchHandler.getTooltipAffordanceString() : "");
        }
        this.inputChanged = false;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        return new RElementInfoHoverCreator(this.mode | 0x10);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("org.eclipse.debug.ui.DetailPaneFont") || property.equals("org.eclipse.jface.defaultfont")) {
            this.dispose();
        }
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        super.dispose();
    }

    private class OpenInEditorItem
    extends SimpleContributionItem {
        public OpenInEditorItem() {
            super(Messages.RElementInfo_OpenDataViewer_label, null, PlatformUI.getWorkbench().getEditorRegistry().findEditor("org.eclipse.statet.r.editors.RData").getImageDescriptor(), null);
        }

        public boolean isEnabled() {
            RElementInfoTask.RElementInfoData input = RElementInfoControl.this.getInput();
            if (input != null) {
                CombinedRElement rElement = input.getElement();
                return rElement != null && RLiveDataEditorInput.isSupported((RObject)rElement) && input.getTool() instanceof ToolProcess;
            }
            return false;
        }

        protected void execute() throws ExecutionException {
            RElementInfoTask.RElementInfoData input = RElementInfoControl.this.getInput();
            if (input != null) {
                RTool tool = input.getTool();
                RElementName elementName = input.getElementName();
                RDataEditor.open(input.getWorkbenchPart().getSite().getPage(), tool, elementName, null);
                return;
            }
        }
    }
}

