/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.selection;

import org.eclipse.statet.ecommons.waltable.command.AbstractLayerCommandHandler;
import org.eclipse.statet.ecommons.waltable.coordinate.PositionCoordinate;
import org.eclipse.statet.ecommons.waltable.selection.SelectRelativeCellCommand;
import org.eclipse.statet.ecommons.waltable.selection.SelectionLayer;

public class SelectRelativeCommandHandler
extends AbstractLayerCommandHandler<SelectRelativeCellCommand> {
    protected final SelectionLayer selectionLayer;

    public SelectRelativeCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<SelectRelativeCellCommand> getCommandClass() {
        return SelectRelativeCellCommand.class;
    }

    @Override
    protected boolean doCommand(SelectRelativeCellCommand command) {
        this.select(command);
        return true;
    }

    protected boolean select(SelectRelativeCellCommand command) {
        long column;
        long row;
        PositionCoordinate lastSelectedCell = null;
        lastSelectedCell = (command.getSelectionFlags() & 0x20000) == 131072 ? this.selectionLayer.getLastSelectedCellPosition() : this.selectionLayer.getSelectionAnchor();
        switch (command.getDirection()) {
            case UP: {
                if (command.getStepCount() == -1L) {
                    row = 0L;
                } else if (lastSelectedCell.rowPosition >= 0L) {
                    row = lastSelectedCell.rowPosition - command.getStepCount();
                    if (row < 0L) {
                        row = 0L;
                    }
                } else {
                    row = 0L;
                }
                column = lastSelectedCell.columnPosition;
                if (column >= 0L) break;
                column = 0L;
                break;
            }
            case DOWN: {
                if (command.getStepCount() == -1L) {
                    row = this.selectionLayer.getRowCount() - 1L;
                } else if (lastSelectedCell.rowPosition >= 0L) {
                    row = lastSelectedCell.rowPosition + command.getStepCount();
                    if (row >= this.selectionLayer.getRowCount()) {
                        row = this.selectionLayer.getRowCount() - 1L;
                    }
                } else {
                    row = 0L;
                }
                column = lastSelectedCell.columnPosition;
                if (column >= 0L) break;
                column = 0L;
                break;
            }
            case LEFT: {
                if (command.getStepCount() == -1L) {
                    column = 0L;
                } else if (lastSelectedCell.columnPosition >= 0L) {
                    column = lastSelectedCell.columnPosition - command.getStepCount();
                    if (column < 0L) {
                        column = 0L;
                    }
                } else {
                    column = 0L;
                }
                row = lastSelectedCell.rowPosition;
                if (row >= 0L) break;
                row = 0L;
                break;
            }
            case RIGHT: {
                if (command.getStepCount() == -1L) {
                    column = this.selectionLayer.getColumnCount() - 1L;
                } else if (lastSelectedCell.columnPosition >= 0L) {
                    column = lastSelectedCell.columnPosition + command.getStepCount();
                    if (column >= this.selectionLayer.getColumnCount()) {
                        column = this.selectionLayer.getColumnCount() - 1L;
                    }
                } else {
                    column = 0L;
                }
                row = lastSelectedCell.rowPosition;
                if (row >= 0L) break;
                row = 0L;
                break;
            }
            default: {
                return false;
            }
        }
        this.selectionLayer.selectCell(column, row, command.getSelectionFlags());
        this.selectionLayer.fireCellSelectionEvent(column, row, true);
        return true;
    }
}

