/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNode;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScan;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeScanner;
import org.eclipse.statet.ecommons.text.core.treepartitioner.TreePartitionNodeType;
import org.eclipse.statet.internal.yaml.snakeyaml.scanner.ScannerImpl;
import org.eclipse.statet.yaml.core.source.YamlPartitionNodeType;
import org.yaml.snakeyaml.reader.StreamReader;
import org.yaml.snakeyaml.tokens.Token;

public class YamlPartitionNodeScanner
implements TreePartitionNodeScanner {
    private final ScannerImpl scanner = new ScannerImpl(new StreamReader(""), false, false, false){

        @Override
        protected void handleComment(int startIndex, int endIndex) {
            YamlPartitionNodeScanner.this.comments.addLast(new Pos(startIndex, endIndex));
        }
    };
    private final Deque<Pos> comments = new ArrayDeque<Pos>();
    private TreePartitionNodeScan scan;
    private TreePartitionNode rootNode;
    private TreePartitionNode node;
    private YamlPartitionNodeType type;

    /*
     * Unable to fully structure code
     */
    public static final TreePartitionNode findYamlRootNode(TreePartitionNode node) {
        while (true) {
            if (node == null) {
                return null;
            }
            if (node.getType() instanceof YamlPartitionNodeType) ** GOTO lbl8
            node = node.getParent();
        }
lbl-1000:
        // 1 sources

        {
            node = parentNode;
lbl8:
            // 2 sources

            ** while ((parentNode = node.getParent()) != null && parentNode.getType() instanceof YamlPartitionNodeType)
        }
lbl9:
        // 1 sources

        return node;
    }

    public int getRestartOffset(TreePartitionNode node, IDocument document, int offset) throws BadLocationException {
        YamlPartitionNodeType rootType = this.getDefaultRootType();
        TreePartitionNode parent = node.getParent();
        if (parent != null) {
            while (parent.getType() != rootType) {
                node = parent;
                parent = node.getParent();
            }
            int idx = parent.indexOfChild(node);
            do {
                int line = document.getLineOfOffset(node.getStartOffset());
                offset = document.getLineOffset(line);
            } while (idx > 0 && offset < (node = parent.getChild(--idx)).getEndOffset());
        }
        return offset;
    }

    public YamlPartitionNodeType getDefaultRootType() {
        return YamlPartitionNodeType.DEFAULT_ROOT;
    }

    public void execute(TreePartitionNodeScan scan) {
        this.scan = scan;
        this.node = null;
        this.comments.clear();
        this.setRange(scan.getStartOffset(), scan.getEndOffset());
        this.init();
        assert (this.rootNode != null && this.node != null);
        this.process();
    }

    protected TreePartitionNodeScan getScan() {
        return this.scan;
    }

    protected void setRange(int startOffset, int endOffset) {
        try {
            String s = this.getScan().getDocument().get(startOffset, endOffset - startOffset);
            this.scanner.reset(s, startOffset);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void init() {
        TreePartitionNode beginNode = this.getScan().getBeginNode();
        if (beginNode.getType() instanceof YamlPartitionNodeType) {
            this.initNode(beginNode, (YamlPartitionNodeType)beginNode.getType());
        } else {
            this.node = beginNode;
            this.addNode(this.getDefaultRootType(), this.getScan().getStartOffset());
            this.rootNode = this.node;
        }
    }

    protected final void initNode(TreePartitionNode node, YamlPartitionNodeType type) {
        if (this.node != null) {
            throw new IllegalStateException();
        }
        this.node = node;
        this.type = type;
        this.rootNode = YamlPartitionNodeScanner.findYamlRootNode(node);
    }

    protected final void addNode(YamlPartitionNodeType type, int offset) {
        this.checkComment(offset);
        this.node = this.scan.add((TreePartitionNodeType)type, this.node, offset, 0);
        this.type = type;
    }

    protected final TreePartitionNode getNode() {
        return this.node;
    }

    protected final void exitNode(int offset, int flags) {
        this.checkComment(offset);
        this.scan.expand(this.node, offset, flags, true);
        this.node = this.node.getParent();
        this.type = (YamlPartitionNodeType)this.node.getType();
    }

    protected final boolean exitNode(YamlPartitionNodeType type, YamlPartitionNodeType typeAlt, int offset) {
        int n = 1;
        TreePartitionNode aNode = this.node;
        while (aNode != null) {
            TreePartitionNodeType aType = aNode.getType();
            if (aType == type || aType == typeAlt) {
                while (n > 0) {
                    this.exitNode(offset, 0);
                    --n;
                }
                return true;
            }
            if (!(aType instanceof YamlPartitionNodeType)) {
                return false;
            }
            aNode = aNode.getParent();
            ++n;
        }
        return false;
    }

    protected final void exitNodesTo(TreePartitionNode stopNode, int offset, int flags) {
        while (this.node != stopNode) {
            this.exitNode(offset, flags);
        }
    }

    private void process() {
        boolean key = false;
        while (true) {
            Token token;
            if ((token = this.scanner.nextToken()) == null) {
                this.handleEOF(this.type);
                return;
            }
            switch (token.getTokenId()) {
                case DocumentEnd: 
                case DocumentStart: 
                case StreamEnd: 
                case StreamStart: {
                    this.exitNodesTo(this.rootNode, token.getStartMark().getIndex(), 0);
                    this.checkComment(token.getStartMark().getIndex());
                    break;
                }
                case Directive: {
                    this.addNode(YamlPartitionNodeType.DIRECTIVE, token.getStartMark().getIndex());
                    this.exitNode(token.getEndMark().getIndex(), 0);
                    break;
                }
                case BlockMappingStart: {
                    this.addNode(YamlPartitionNodeType.BLOCK_MAPPING, token.getStartMark().getIndex());
                    break;
                }
                case BlockSequenceStart: {
                    this.addNode(YamlPartitionNodeType.BLOCK_SEQUENCE, token.getStartMark().getIndex());
                    break;
                }
                case BlockEntry: {
                    break;
                }
                case BlockEnd: {
                    this.exitNode(YamlPartitionNodeType.BLOCK_MAPPING, YamlPartitionNodeType.BLOCK_SEQUENCE, token.getEndMark().getIndex());
                    break;
                }
                case FlowMappingStart: {
                    this.addNode(YamlPartitionNodeType.FLOAT_MAPPING, token.getStartMark().getIndex());
                    break;
                }
                case FlowSequenceStart: {
                    this.addNode(YamlPartitionNodeType.FLOAT_SEQUENCE, token.getStartMark().getIndex());
                    break;
                }
                case FlowEntry: {
                    break;
                }
                case FlowMappingEnd: {
                    this.exitNode(YamlPartitionNodeType.FLOAT_MAPPING, null, token.getEndMark().getIndex());
                    break;
                }
                case FlowSequenceEnd: {
                    this.exitNode(YamlPartitionNodeType.FLOAT_SEQUENCE, null, token.getEndMark().getIndex());
                    break;
                }
                case Key: {
                    key = true;
                    break;
                }
                case Tag: {
                    this.addNode(YamlPartitionNodeType.TAG, token.getStartMark().getIndex());
                    this.exitNode(token.getEndMark().getIndex(), 0);
                    break;
                }
                case Alias: 
                case Anchor: {
                    break;
                }
                case Value: {
                    key = false;
                    break;
                }
                case Scalar: {
                    this.addNode(key ? YamlPartitionNodeType.KEY : YamlPartitionNodeType.VALUE, token.getStartMark().getIndex());
                    this.exitNode(token.getEndMark().getIndex(), 0);
                }
            }
        }
    }

    private void checkComment(int offset) {
        while (!this.comments.isEmpty()) {
            Pos pos = this.comments.getFirst();
            if (pos.getStartOffset() >= offset) break;
            this.comments.removeFirst();
            TreePartitionNode commentNode = this.scan.add((TreePartitionNodeType)YamlPartitionNodeType.COMMENT_LINE, this.node, pos.getStartOffset(), 0);
            this.scan.expand(commentNode, pos.getEndOffset(), 0, true);
        }
    }

    protected void handleEOF(YamlPartitionNodeType type) {
        this.scan.expand(this.node, this.scan.getEndOffset(), 0, true);
    }

    private static class Pos {
        private final int startOffset;
        private final int endOffset;

        public Pos(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

